<?php
/****************************************
/*  Author  : Kvvaradha
/*  Module  : Kvcodes CRM
/*  E-mail  : admin@kvcodes.com
/*  Version : 1.0
/*  Http    : www.kvcodes.com
*****************************************/
include_once($path_to_root. '/includes/ui/simple_crud_class.inc');

class activity extends simple_crud {
	var $selected_id;
	var $entity;
	var $sub_class;
	var $class;
	
	function __construct($name, $id, $class, $subclass=null) {
		$fields = array('type', 'type_id','name','description','medium', 'date', 'medium_to', 'reminder_date', 'alert', 'status');

		parent::__construct($name, $fields);
		$this->class = $class;
		$this->subclass = $subclass;
		$this->entity = $id;		
	}

	function list_view() {
		br();
		
		$degree = GetDataJoin('kv_crm_activities AS act', array( 
					0 => array('join' => 'INNER', 'table_name' => 'kv_crm_picklist_values AS vales', 'conditions' => '`vales`.`id2` = `act`.`status` AND `vales`.`picklist_id` = 4'), 
					1 => array('join' => 'LEFT', 'table_name' => 'kv_crm_picklist_values AS medium', 'conditions' => '`medium`.`id2` = `act`.`medium` AND `medium`.`picklist_id` = 6'),
					2 => array('join' => 'LEFT', 'table_name' => 'kv_crm_picklist_values AS medium_to', 'conditions' => '`medium_to`.`id2` = `act`.`medium_to` AND `medium_to`.`picklist_id` = 6'),
						), 
			array('`act`.`id`, `act`.`name`, `act`.`description`, `medium`.`description` AS Medium, `act`.`date`, `act`.`alert`, `act`.`reminder_date`, `medium_to`.`description` AS Medium_to, `vales`. `description` AS status'), 
			array('`act`.`type_id`' => $this->entity, '`act`.`type`' => $_GET['type']));			
		start_table(TABLESTYLE, "width=80%");
		$th = array(_("ID"), _("Name"), _("Description"), _("Medium"), _("Date"), _("Reminder Date"), _("Remind"), _("Medium To"),_("Status"), "", "");	
		table_header($th);
		if(is_array($degree) && count_array($degree) > 0){		
			foreach($degree as $de) {				
				label_cell($de['id']);					
				label_cell($de['name']);
				label_cell($de['description']);
				label_cell($de['Medium']);			
				label_cell(sql2date($de['date']));
				label_cell(($de['reminder_date'] != '0000-00-00' && $de['alert']) ? sql2date($de['reminder_date']) : '' );
				label_cell(($de['alert'] == 1 ? 'Yes' : 'No'));
				label_cell($de['Medium_to']);
				label_cell($de['status']);	
				edit_button_cell("{$this->name}Edit[{$de['id']}]", _("Edit"));
				delete_button_cell("{$this->name}Delete[{$de['id']}]", _("Delete"));
				end_row();	
			}
		} else {
			start_row();
			label_cell(_("No Activity Found"), 'colspan="11"');
		}
		end_table(1);
	}
	
	function editor_view(){
		global $Ajax;
		br();
		$this->list_view();
		div_start('Activity_Details');	
		start_outer_table(TABLESTYLE);
	
		table_section(1);
		table_section_title(_("Activity Detail"));

		if(list_updated('alert')){
			$alert = get_post('alert');
			$name = get_post('name');
			$_POST['alert'] = ((isset($_POST['alert']) && $_POST['alert'] == 1 ) ? 0 : 1);			
			$Ajax->activate('Activity_Details');
		}		

		if($this->selected_id != null && $this->selected_id != "" && $this->selected_id != 0) {
			$de = GetRow('kv_crm_activities', array( 'id' => $this->selected_id));	
			$_POST['date'] = sql2date($de['date']);
			$_POST['reminder_date'] = sql2date($de['reminder_date']);
			if(list_updated('alert')){
				$_POST['alert'] = (!isset($_POST['alert']) ? $de['alert'] : $_POST['alert']);
			}
			$_POST['description'] = $de['description'];
			$_POST['status'] = $de['status'];
			$_POST['name'] = $de['name'];			
			
		}else {
			$_POST['name'] = (isset($name) ? $name : '' ); //get_post('name');
			$_POST['description'] = get_post('description');			
		}
		
		text_row(_("Name :"), 'name', null, 35, 40);		
		textarea_row(_("Description:"), 'description', null, 45, 8);			
		date_row(_("Date:"), 'date');	
		kv_common_type_row(_("Medium"), 'medium', null,  _("Select a Medium"), false, 6);
		check_row(_("Set Reminder"), 'alert');
		
		// if(get_post('_alert_update')){
		// 	$_POST['alert'] = get_post('alert');
		// 	$Ajax->activate('Activity_Details');
		// }
		// if($_POST['alert']){
			date_row(_("Reminder Date:"), 'reminder_date');
			kv_common_type_row(_("Medium To Remind"), 'medium_to', null,  _("Select"), false, 6);	
		// }else{
		// 	hidden('reminder_date',sql2date('0000-00-00'));
		// 	hidden('medium_to',0);
		// }
		kv_common_type_row(_("Status"), 'status', null,  false, false, 4);					
			
		hidden('type', $_GET['type']);
		end_outer_table(1);	
		div_end();
	}

	function _bottom_controls()	{
		$title=false;
		$async='both';
		$base=$this->name;

		$cancel = $async;

		if ($async === 'both') {
			$async = 'default'; $cancel = 'cancel';
		} 
		else if ($async === 'default')
			$cancel = true;
		else if ($async === 'cancel')
			$async = true;
		echo "<center>";

		if ($this->Mode == '' || $this->Mode == 'RESET')
			submit("{$base}NEW", _("Add new"), true, $title, $async);
		else {
			if ($this->Mode == 'NEW' || $this->selected_id==$this->_none)				
				submit("{$base}ADD", _("Add"), true, $title, $async);
			else 
				submit("{$base}UPDATE[{$this->selected_id}]", _("Update"), true, _("Submit changes"), $async);		
			
			submit("{$base}RESET", _("Cancel"), true, _("Cancel edition"), $cancel);
		}
		echo "</center>";
	}
	
	function db_insert() {
		$dat = $this->data;			
		return Insert('kv_crm_activities', array('type_id' => $this->entity, 'type' => $dat['type'],'name' => $dat['name'], 'description' => $dat['description'],  'medium' => $dat['medium'], 'medium_to' => $dat['medium_to'], 'date' => array($dat['date'], 'date'), 'reminder_date' => array($dat['reminder_date'], 'date'), 'alert' =>check_value('alert'),'user' => $_SESSION["wa_current_user"]->user, 'status' => $dat['status']));
		display_notification(_("A new Activity Added Successfully"));
	}

	function db_update() {
		$dat = $this->data;
		return Update('kv_crm_activities', array( 'id' => $this->selected_id), array('type_id' => $this->entity, 'type' => $dat['type'], 'name' => $dat['name'], 'description' => $dat['description'], 'medium' => $dat['medium'], 'medium_to' => $dat['medium_to'], 'date' => array($dat['date'], 'date'), 'reminder_date' => array($dat['reminder_date'], 'date'), 'alert' => check_value('alert'),'status' => $dat['status']) );
		display_notification(_("The Selected Activity Updated Successfully"));
	}

	function insert_check() {
		if (strlen($_POST['name']) == 0) {
			display_error(_("The activity name cannot be empty."));
			set_focus('name');
			return false;
		}
		if (strlen($_POST['description']) == 0) {
			display_error(_("Description cannot be empty."));
			set_focus('description');
			return false;
		}
		if (!is_date(@$_POST['date'])) {
			display_error(_("Invalid Date."));
			set_focus('grade');
			return false;
		}
		return true; 
	}

	function db_read() {
		//display_error($this->entity.'-'.$this->selected_id);
		return GetRow('kv_crm_activities', array('id' => $this->selected_id)); //, 'type' => $this->entity));
	}
	
	function delete_check() {
		return true;
	}

	//	Delete all degree for degree in current class/entity
	function db_delete() {
		if (Delete('kv_crm_activities', array('id' => $this->selected_id))) {	
			display_notification(_("The Selected Activity Deleted Successfully"));
		}
		return false;
	}
}

?>