<?php
/****************************************
/*  Author  : Kvvaradha
/*  Module  : Kvcodes CRM
/*  E-mail  : admin@kvcodes.com
/*  Version : 1.0
/*  Http    : www.kvcodes.com
*****************************************/
include_once($path_to_root. '/includes/ui/simple_crud_class.inc');

class crm_comments extends crm_simple_crud {
	var $selected_id;
	var $entity;
	var $sub_class;
	var $class;
	
	function __construct($name, $id, $class, $subclass=null) {
		$fields = array('cmt_type', 'type_id','user_id','description','date', 'status');

		parent::__construct($name, $fields);
		$this->class = $class;
		$this->subclass = $subclass;
		$this->entity = $id;		
	}

	function list_view() {
		br();
		// $degree = Gee_GetDataJoin('kv_crm_comments AS act', array( 
						
		// 				0 => array('join' => 'LEFT', 'table_name' => 'users AS user', 'conditions' => '`user`.`id` = `act`.`user_id`')	), 
		// 	array('`user`.`real_name`, `act`.`description`, `act`.`date`, `act`.`id`'), 
		// 	array('`act`.`type_id`' => $this->entity, '`act`.`type`' => (isset($_GET['task_type']) ? $_GET['task_type'] : $_GET['type'])),null,false,true);			
		start_table(TABLESTYLE, "width=80%");
		$degree =$this->db_read();
		$th = array( _("Name"), _("Comment"), _("Date"),  "", "");	
		table_header($th);		
		if(is_array($degree) && !empty($degree)){
			foreach($degree as $de) {				
				//label_cell($de['id']);					
				label_cell($de['real_name']);
				label_cell(nl2br($de['description']));
				label_cell(sql2date($de['date']));		
					
				edit_button_cell("{$this->name}Edit[{$de['id']}]", _("Edit"));
				delete_button_cell("{$this->name}Delete[{$de['id']}]", _("Delete"));
				end_row();	
			}
		}
		end_table(1);
	}
	
	function editor_view(){
		//global $Ajax;
		br();
		div_start('Comment_Details');	
		start_outer_table(TABLESTYLE);
	
		table_section(1);
		table_section_title(_("Comment Detail"));

		if($this->selected_id != null || $this->selected_id != "") {
			$de = GetRow('kv_crm_comments', array( 'id' => $this->selected_id));	
			$_POST['date'] = sql2date($de['date']);
			
			$_POST['description'] = $de['description'];
			$_POST['status'] = $de['status'];
			$_POST['user_id'] = $de['user_id'];		
			hidden('user_id', $_POST['user_id']);
			label_row(_("Name :"), GetSingleValue('users', 'real_name', array('id' => get_post('user_id'))));
		}else{
			hidden('user_id', $_SESSION['wa_current_user']->user);
			label_row(_("Name :"), $_SESSION['wa_current_user']->name);
		}		
		
		textarea_row(_("Comment:"), 'description', null, 45, 8);			
		//date_row(_("Date:"), 'date');		
		hidden('date', Today());
				
		hidden('status', 0);
		if(isset($_GET['task_type']))
			$type = $_GET['task_type'];
		else
			$type= $_GET['type'];
		hidden('cmt_type', $type);
		end_outer_table(1);	
		div_end();
	}

	function _bottom_controls()	{
		$title=false;
		$async='both';
		$base=$this->name;

		$cancel = $async;

		if ($async === 'both') {
			$async = 'default'; $cancel = 'cancel';
		} 
		else if ($async === 'default')
			$cancel = true;
		else if ($async === 'cancel')
			$async = true;
		echo "<center>";

		if ($this->Mode == '' || $this->Mode == 'RESET')
			submit("{$base}NEW", _("Add new"), true, $title, $async);
		else {
			if ($this->Mode == 'NEW' || $this->selected_id==$this->_none)
				
				submit("{$base}ADD", _("Add"), true, $title, $async);
			else {
				submit("{$base}UPDATE[{$this->selected_id}]", _("Update"), true, _("Submit changes"), $async);				
			}
			submit("{$base}RESET", _("Cancel"), true, _("Cancel edition"), $cancel);
		}
		echo "</center>";
	}
	
	function db_insert() {
		$dat = $this->data;			
		$return = Insert('kv_crm_comments', array('type_id' => $this->entity, 'type' => $dat['cmt_type'],'user_id' => $dat['user_id'], 'description' => $dat['description'],  'date' => array($dat['date'], 'date'), 'status' => $dat['status']));

		// if($dat['type'] == 4) {  //Task Comment
		// 	$task = GetRow('kv_crm_tasks', array('id' => $this->entity));
		// 	if($_SESSION['wa_current_user']->user != $task['staffid']) { // Sent to Staff 			
		// 		$staff = GetRow('users', array('id' => $task['staffid']));
		// 	} else 
		// 		$staff = GetRow('users', array('id' => $task['addedfrom']));	
			
		// 	$details = array( 'task_name' => $task['name'], 'task_comment' => $dat['description'],'real_name' => $staff['real_name'], 'phone' => $staff['phone'],'email' => $staff['email']);
		// 	$to =  array('name' => $staff['real_name'], 'email' => $staff['email']);
		// 	$template = array('slug' => 'task-commented',  'details' => $details );	
		// }
		// // display_error(json_encode($template));
		// kv_mail($to, '', '', "html", array(), null, false, $template);
		// display_notification(_("A new Comment Added Successfully"));
		// return $id;	
	}

	function db_update() {
		$dat = $this->data;
		Update('kv_crm_comments', array( 'id' => $this->selected_id), array('type_id' => $this->entity, 'type' => $dat['cmt_type'], 'user_id' => $dat['user_id'], 'description' => $dat['description'],  'date' => array($dat['date'], 'date'), 'status' => $dat['status']) );
		display_notification(_("The Selected Comment Updated Successfully"));
		return true;
	}

	function insert_check() {
		/*if (strlen($_POST['user_id']) == 0) {
			display_error(_("The comment Person name cannot be empty."));
			set_focus('user_id');
			return false;
		}*/
		if (strlen($_POST['description']) == 0) {
			display_error(_("Description cannot be empty."));
			set_focus('description');
			return false;
		}
		if (!is_date(@$_POST['date'])) {
			display_error(_("Invalid Date."));
			set_focus('grade');
			return false;
		}
		return true; 
	}

	function db_read() {
		return GetDataJoin ('kv_crm_comments as comments',
			array(0=>array('join' => 'LEFT', 'table_name' => 'users AS user', 'conditions' => 'user.id =comments.user_id')),
			array('comments.*','user.real_name'),
			array('type_id'=>$this->entity,'type'=>(isset($_GET['task_type']) ? $_GET['task_type'] : $_GET['type']))
		);


		// return GetAll('kv_crm_comments', array('type'=>(isset($_GET['task_type']) ? $_GET['task_type'] : $_GET['type']),'type_id' => $this->entity));
	}
	function db_edit_read() {
		return GetAll('kv_crm_attachments', array('type_id' => $this->selected_id));
	}
	function delete_check() {
		return true;
	}

	//	Delete all degree for degree in current class/entity
	function db_delete() {
		if (Delete('kv_crm_comments', array('id' => $this->selected_id))) {	
			display_notification(_("The Selected Comment Deleted Successfully"));
		}
		return false;
	}
}

?>
