<?php
$page_security = 'SA_SUPPLIERANALYTIC';

$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/db/crm_contacts_db.inc");

//----------------------------------------------------------------------------------------------------

print_invoices();

//----------------------------------------------------------------------------------------------------
function get_invoice($from, $to, $supplier)
{
 $from = date2sql($from);
 $to = date2sql($to);

$sql = "SELECT trans.*, supplier.supp_name, supplier.supp_ref
 FROM "
 .TB_PREF."supp_trans trans,"
 .TB_PREF."suppliers supplier
 WHERE trans.supplier_id = supplier.supplier_id
 AND trans.tran_date >= ".db_escape($from)."
 AND trans.tran_date <= ".db_escape($to)."
 AND trans.type = ".ST_SUPPINVOICE."
 AND trans.ov_amount != 0";

if($supplier)
 $sql .= " AND trans.supplier_id =".db_escape($supplier);

$result = db_query($sql, "The invoice cannot be retrieved");

return $result;
}

function print_invoices()
{
 global $path_to_root, $systypes_array;

$from = $_POST['PARAM_0'];
 $to = $_POST['PARAM_1'];
 $supplier = $_POST['PARAM_2'];
 $orientation = $_POST['PARAM_3'];
 $destination = $_POST['PARAM_4'];

if (!$from || !$to) return;

if ($destination)
 include_once($path_to_root . "/reporting/includes/excel_report.inc");
 else
 include_once($path_to_root . "/reporting/includes/pdf_report.inc");

$orientation = ($orientation ? 'L' : 'P');

$dec = user_price_dec();




$cols = array(0, 150, 200, 250, 300, 350, 400, 475, 550);

$headers = array(_('Supplier'), _('Invoice No.'), _('Reference'), _('Invoice Date'), _('Due Date'),
 _('DPP Amount'), _('Tax Amount'), _('Invoice Amount'));

$aligns = array('left', 'left', 'left', 'left', 'left', 'right', 'right', 'right');

$params = array( 0 => $comments,
 1 => array('text' => _('Period'), 'from' => $from, 'to' => $to));

$rep = new FrontReport(_('Supplier Invoice Transactions'), "SupplierInvoiceTransactions", user_pagesize(), 8, $orientation);
 if ($orientation == 'L')
 recalculate_cols($cols);

$rep->Font();
 $rep->Info($params, $cols, $headers, $aligns);
 $rep->NewPage();

$result = get_invoice($from, $to, $supplier);

while ($myrow=db_fetch($result))
 {
 $counter += 1;

if($counter > 1)
 $rep->NewLine(1.5);

$rep->TextCol(0, 1, $myrow['supp_ref'] ." - ". $myrow['supp_name']);
 $rep->TextCol(1, 2, $myrow['supp_reference']);
 $rep->TextCol(2, 3, $myrow['reference']);
 $rep->DateCol(3, 4, $myrow['tran_date'], true);
 $rep->DateCol(4, 5, $myrow['due_date'], true);
 $rep->AmountCol(5, 6, ($myrow['ov_amount'] + $myrow['ov_discount']) * $myrow['rate'], $dec);
 $rep->AmountCol(6, 7, $myrow['ov_gst'] * $myrow['rate'], $dec);
 $rep->AmountCol(7, 8, ($myrow['ov_amount'] + $myrow['ov_discount'] + $myrow['ov_gst']) * $myrow['rate'], $dec);

$DPPSum += ($myrow['ov_amount'] + $myrow['ov_discount']) * $myrow['rate'];
 $taxSum += $myrow['ov_gst'] * $myrow['rate'];
 $invSum += ($myrow['ov_amount'] + $myrow['ov_discount'] + $myrow['ov_gst']) * $myrow['rate'];
 }

if($counter)
 {
 $rep->Line($rep->row - 4);
 $rep->NewLine(1.5);
 $rep->fontSize += 1;
 $rep->TextCol(0, 3, _('Grand Total'));
 $rep->AmountCol(5, 6, $DPPSum, $dec);
 $rep->AmountCol(6, 7, $taxSum, $dec);
 $rep->AmountCol(7, 8, $invSum, $dec);
 $rep->Line($rep->row - 4);
 $rep->NewLine();
 }
 $rep->End();
}