<?php
// ----------------------------------------------------------------
// Creator: Kvvaradha
// email:   admin@kvcodes.com
// Title:   HRM Extention for Frontaccounting
// website: http://www.kvcodes.com
// ----------------------------------------------------------------

function hrm_viewer_link($type, $trans_no, $label="", $icon=false, $class='', $id='') {
	//
	if ($type == ST_EMPLOYEE )
		$viewer = "modules/ExtendedHRM/payslip.php?payslip_id=$trans_no&popup=yes";
	elseif ($type == ST_EMPLOYEE_SALARY )
		$viewer = "modules/ExtendedHRM/payslip.php?payslip_id=$trans_no&popup=yes";
	elseif ($type == ST_EMPLOYEE_LOAN )
		$viewer = "modules/ExtendedHRM/inquires/loan_repay.php?loan_id=$trans_no&popup=yes";
	elseif ($type == ST_EMPLOYEE_ADVANCE )
		$viewer = "modules/ExtendedHRM/advance_salary.php?adv_id=$trans_no&popup=yes";
	elseif ($type == ST_EMPLOYEE_PETROL )
		$viewer = "modules/ExtendedHRM/petrol.php?petrol_id=$trans_no&popup=yes";
	elseif ($type == ST_EMPLOYEE_TRAVEL )
		$viewer = "modules/ExtendedHRM/travel.php?travel_id=$trans_no&popup=yes";
	elseif ($type == ST_EMPLOYEE_ENCASHMENT )
		return null;
	else
		$viewer = "gl/view/gl_trans_view.php?type_id=$id&trans_no=$trans_no";

	if ($label == "")
		$label = $trans_no;

	return viewer_link($label, $viewer, $class, $id,  $icon);
}

function employee_list($name, $empl_id=null, $all_option=false, $submit_on_change=false, $show_inactive=false, $editkey = false, $show_all=true, $search=true, $inactive = false,$disabled= false){
	global $all_items;

	$sql = "SELECT empl.empl_id, CONCAT(empl.empl_id, ' - ', empl.empl_firstname, ' ', empl.empl_lastname) AS empl_name, dept.description FROM ".TB_PREF."kv_empl_info empl,".TB_PREF."kv_empl_job job, ".TB_PREF."kv_empl_departments dept WHERE empl.empl_id=job.empl_id AND job.department=dept.id ";

	if(get_post('dept_id'))
		$sql .=" AND job.department=".get_post('dept_id');
	/*if($show_all)
		$sql .= " AND empl.status=1";
	elseif($inactive)
		$sql .= " AND empl.status != 1";*/
	if(basename($_SERVER['PHP_SELF']) == 'esb.php'){
			$sql .= " AND empl.status != 1";
	}else{
		if(get_post('show_inactive'))
			$sql .=" AND empl.status <> 1 ";
		elseif($show_all == false)
			$sql .= " AND empl.status = 1";
		else{
			//$sql .= " AND empl.status == 1 " ;
			if($show_all == 2 && $show_all != 1)
				$sql .= " AND empl.status != 1 ";
			elseif($show_all == true)
				$sql .= " AND empl.status=1";
		}
	}
	if(get_post('dept_id'))
		$sql .=" AND job.department=".get_post('dept_id');
	if ($editkey)
		set_editor('employee', $name, $editkey);
	$mode = 0;
	$ret = combo_input($name, $empl_id, $sql, 'empl.empl_id', 'empl_name',
	array_merge(
	  array(
		'format' => '_format_empl',
			'spec_option' => $all_option===true ?  _("All Employees") : $all_option,
			'spec_id' => ALL_TEXT,
			'search_box' => $search,
			'search' => array("empl.empl_id", "dept.description","empl_name"),
			'search_submit' => get_company_pref('no_employee_list')!=0,
			'size'=>20,
			'select_submit'=> $submit_on_change,
			'category' => 2,
			'disabled' => $disabled,
			'order' => array( 'dept.description','empl_name'),
			'editable' => false,
			'max' => 255
		  )) );
	if ($editkey)
		$ret .= add_edit_combo('item');		
	return $ret;	  
}

function _format_empl($row){
	return (user_show_codes() ?  ($row[0] . "&nbsp;-&nbsp;") : "") . $row[1];
}

function employee_list_cells($label, $name, $empl_id=null, $all_option=false, $submit_on_change=false, $all=false, $editkey = false, $show_all= true, $search=false, $inactive=false,$disabled= false ){
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td nowrap>";
	echo employee_list($name, $empl_id, $all_option, $submit_on_change,	array('cells'=>true, 'show_inactive'=>$all), $editkey, $show_all,$search, $inactive,$disabled);
	echo "</td>\n";
}

function employee_list_row($label, $name, $empl_id=null, $all_option=false, $submit_on_change=false, $all=false, $editkey = false, $show_all= true,$search=false, $inactive=false,$disabled= false){
	echo "<tr><td class='label'>$label</td>";
	employee_list_cells(null, $name, $empl_id, $all_option, $submit_on_change, $all, $editkey, $show_all,$search, $inactive,$disabled);
	echo "</tr>\n";
}

function empl_img_name($empl_id){
	$empl_id = strtr($empl_id, "><\\/:|*?", '________');
	return clean_file_name($empl_id);
}

//-----------------------------------------------------------------------------------
function kv_hrm_image_cells($label, $name, $id=""){
	if ($id != "")
		$id = "id='$id'";
	label_cells($label, "<input type='file' name='$name' $id  'image/*'/>");
}		
function kv_hrm_image_row($label, $name, $id = ""){
	echo "<tr><td class='label'>$label</td>";
	kv_hrm_image_cells(null, $name, $id);
	echo "</tr>\n";
}	

//-----------------------------------------------------------------------------------
function kv_doc_cells($label, $name, $id=""){
	if ($id != "")
		$id = "id='$id'";
	label_cells($label, "<input type='file' name='$name' $id  accept='.doc,.docx, .rtf, .txt, .jpg, .png, .jpeg, .gif, .bmp, .pdf'/>");
}		
function kv_doc_row($label, $name, $id = ""){
	echo "<tr><td class='label'>$label</td>";
	kv_doc_cells(null, $name, $id);
	echo "</tr>\n";
}

function empl_leave_data($empl_id) {
	br();
	//div_start('details');			
	start_table();
		kv_fiscalyears_list_row(_("Fiscal Year").":", 'attendance_year', null, true);
	end_table();
	br();
	$selected_empl = get_employee_whole_attendance($empl_id, get_post('attendance_year'));
		// $selected_empl = GetSingleValue('kv_empl_job', 'department', array('empl_id' => $empl_id));
	$payroll_monthly_choice =get_hrm_option('monthly_choice');
	$hrmsetup = get_hrm_option();
	if(!empty($selected_empl)){
			// $total_days =  31;
		$months_list = kv_get_months_in_fiscal_year();
		$months_array_count = array_keys($months_list);
		start_table(TABLESTYLE);
		$th = array(_("Year"),_("Month"));	

		if($payroll_monthly_choice == 1){
			 $total_days =  31;
		for($kv=1; $kv<=$total_days; $kv++){						
			$th[] = $kv;
		}	
		}elseif($payroll_monthly_choice == 2){
			$vj= 1;
			if($hrmsetup['BeginDay'] >= 1 && $hrmsetup['BeginDay'] < 31){
				$kv = $hrmsetup['BeginDay'];
				$kv_begin_days = $hrmsetup['BeginDay'];
				$month=$year=0;
				$pre_mnth =  (($month > 1)? ($month-1) : 12);
				$total_days =  date("t", strtotime($year."-".$month."-01"));
				for($kv; $kv<=$total_days; $kv++){		
					$th[] = $kv;
				}	
			}
					
			if($hrmsetup['EndDay'] < 31){ 
				$kv_end_days = $hrmsetup['EndDay'];
				$nxt_mnth =  (($month > 1)? ($month+1) : 12);

				for($kv=1;$kv<=$hrmsetup['EndDay'];$kv++){			
					$th[] = $kv;
				}
			}
		}elseif($payroll_monthly_choice == 3){
			$vj= 1;
			if($hrmsetup['BeginDay'] >= 1 && $hrmsetup['BeginDay'] < 31){
				$kv = $hrmsetup['BeginDay'];
				$kv_begin_days = $hrmsetup['BeginDay'];
				$month=$year=0;
				$pre_mnth =  (($month > 1)? ($month-1) : 12);
				$total_days =  date("t", strtotime($year."-".$pre_mnth."-01"));
				for($kv; $kv<=$total_days; $kv++){		
					$th[] = $kv;
				}	
			}
					
			if($hrmsetup['EndDay'] < 31){ 
				$kv_end_days = $hrmsetup['EndDay'];
				//$nxt_mnth =  (($month < 12)? ($month+1) : '1');

				for($kv=1;$kv<=$hrmsetup['EndDay'];$kv++){			
					$th[] = $kv;
				}
			}
		}

		$th1 = array(_("Worked Days"));			
		$th_final = array_merge($th, $th1);
		table_header($th_final);						
		$total_abs_days = $counted_month = $total_leave = $leaveDays = $AL = $SL = $ML =$HL= 0;			
		foreach ($selected_empl as $month => $single_month) {
			$fiscal_yr = get_fiscalyear(get_post('attendance_year')); 
			$ext_year = date('Y', strtotime($fiscal_yr['begin']));
			echo '<tr style="text-align:center"><td>';
			if($payroll_monthly_choice == 1){
				$date_range_months = sql2date(date("Y-m-d", strtotime($ext_year."-".$month."-01"))).' - '.sql2date(date("Y-m-t", strtotime($ext_year."-".$month."-01")));  

			} elseif($payroll_monthly_choice == 2){
				$date_range_months = sql2date(date("Y-m-d", strtotime($ext_year."-".$month."-".$hrmsetup['BeginDay']))).' - '.sql2date(date("Y-m-t", strtotime($ext_year."-".$month."-".$hrmsetup['EndDay'])));  

			} elseif($payroll_monthly_choice == 3){

					$pre_mnth =  (($month > 1)? ($month-1) : 12);
					if($pre_mnth == 12 )
							$prev_ext_year = $ext_year-1;
						else
							$prev_ext_year = $ext_year;

					$total_days =  date("t", strtotime($prev_ext_year."-".$pre_mnth."-01"));

					$date_range_months = sql2date(date("Y-m-d", strtotime($prev_ext_year."-".$pre_mnth."-".$kv_begin_days))).' - '.sql2date(date("Y-m-d", strtotime($prev_ext_year."-".$pre_mnth."-".$total_days))); 
			}

				//.sql2date($fiscal_yr['begin']).' - '.sql2date($fiscal_yr['end']).

			echo $date_range_months.'</td><td>'._(date("F", strtotime($ext_year."-".$month."-01"))).'</td>';

			if($payroll_monthly_choice == 1){

				$workingDays = 0 ;
				for($vj = 1; $vj <= 31; $vj++){
					echo '<td>'.(isset($single_month[$vj]) ? $single_month[$vj] : '-').'</td>';
					if(isset($single_month[$vj]) && $single_month[$vj] == 'P')
						$workingDays++;
					elseif(isset($single_month[$vj]) && $single_month[$vj] == 'A')
						$leaveDays++;
					elseif(isset($single_month[$vj]) && $single_month[$vj] == 'AL'){
						$AL++;
						$total_leave++;
					}elseif(isset($single_month[$vj]) && $single_month[$vj] == 'SL'){
						$SL++;
						$total_leave++;
					}elseif(isset($single_month[$vj]) && $single_month[$vj] == 'ML'){
						$ML++;
						$total_leave++;
					}elseif(isset($single_month[$vj]) && $single_month[$vj] == 'HL'){
						$HL++;
						$total_leave++;
					}
				}
			}elseif($payroll_monthly_choice == 2){
					$beginDay = date("Y-m-d", strtotime($ext_year."-".$month."-".$hrmsetup['BeginDay']));
					$endDay	= 	date("Y-m-t", strtotime($ext_year."-".$month."-".$hrmsetup['EndDay']));

				$job_row  = GetRow('kv_empl_job', array('empl_id'=>$empl_id));			
						$weekly_off1 = $job_row['weekly_off'];

				$sql = "SELECT * FROM ".TB_PREF."kv_empl_attendance WHERE empl_id=".db_escape($empl_id)." AND a_date >= '".$beginDay."' AND a_date <= '".date("Y-m-t", strtotime($ext_year."-".$month."-01"))."' GROUP BY a_date, dimension ORDER BY a_date ASC";
							$res = db_query($sql, _("Can't get attendance"));
							$final = array();
							while($row2 = db_fetch_assoc($res)){
								$final[$row2['a_date']][$row2['dimension']] = $row2;
							}	
				$workingDays = $pre_mnth = 0 ;
				if( $hrmsetup['EndDay'] < 31){	
						$kv_end_days = $hrmsetup['EndDay'];		
						$nxt_mnth =  (($month > 1)? ($month+1) : 12);	

					$total_days =  date("t", strtotime($ext_year."-".$pre_mnth."-01"));

					$beginDay = date("Y-m-d", strtotime($ext_year."-".$pre_mnth."-".$kv_begin_days));
					$endDay	= 	date("Y-m-d", strtotime($ext_year."-".$pre_mnth."-".$total_days));	
				}

				for($vj=$kv_begin_days; $vj <= 31; $vj++){	
					if(isset($final[date("Y-m-d", strtotime($ext_year."-".$month."-".$vj))])){
									echo '<td>';
									foreach($final[date("Y-m-d", strtotime($ext_year."-".$month."-".$vj))] as $dim => $val){
										$datee = $final[date("Y-m-d", strtotime($ext_year."-".$month."-".$vj))] ;
										// echo $val['code'].'<span>'.($val['code'] == 'P' : '') .'</span>';
										echo (isset($val['code']) ? $val['code'] : '-');
											if(isset($val['code']) && $val['code'] == 'P')
												$workingDays++;
											elseif(isset($val['code']) && $val['code'] == 'A')
												$leaveDays++;
											elseif(isset($val['code']) && $val['code'] == 'AL'){
												$AL++;
												$total_leave++;
											}elseif(isset($val['code']) && $val['code'] == 'SL'){
												$SL++;
												$total_leave++;
											}elseif(isset($val['code']) && $val['code'] == 'ML'){
												$ML++;
												$total_leave++;
											}elseif(isset($val['code']) && $val['code'] == 'HL'){
												$HL++;
												$total_leave++;
											}
									}
									echo '</td>';
								} else{
									$day_letters = date("D", strtotime($ext_year."-".$pre_mnth."-".$vj)) ; 
									if(!is_array($weekly_off1))
										$weekly_off1=array($weekly_off1);
									if( in_array($day_letters, $weekly_off1))								
										echo '<td style="background: #fed;"> '._("OFF").' </td>';
									else
										echo '<td> </td>';
								}
							} 


				$sql = "SELECT * FROM ".TB_PREF."kv_empl_attendance WHERE empl_id=".db_escape($empl_id)." AND a_date >= '".$beginDay."' AND a_date <= '".date("Y-m-t", strtotime($ext_year."-".$nxt_mnth."-01"))."' GROUP BY a_date, dimension ORDER BY a_date ASC";
							$res = db_query($sql, _("Can't get attendance"));
							$final = array();
							while($row2 = db_fetch_assoc($res)){
								$final[$row2['a_date']][$row2['dimension']] = $row2;
							}


				for($vj=1; $vj <=$hrmsetup['EndDay']; $vj++){	
					if(isset($final[date("Y-m-d", strtotime($ext_year."-".$nxt_mnth."-".$vj))])){
						echo '<td>';
						foreach($final[date("Y-m-d", strtotime($ext_year."-".$nxt_mnth."-".$vj))] as $dim => $val){
										$datee = $final[date("Y-m-d", strtotime($ext_year."-".$nxt_mnth."-".$vj))] ;
										// echo $val['code'].'<span>'.($val['code'] == 'P' : '') .'</span>';
										echo (isset($val['code']) ? $val['code'] : '-');

										if(isset($val['code']) && $val['code'] == 'P')
											$workingDays++;
										elseif(isset($val['code']) && $val['code'] == 'A')
											$leaveDays++;
										elseif(isset($val['code']) && $val['code'] == 'AL'){
											$AL++;
											$total_leave++;
										}elseif(isset($val['code']) && $val['code'] == 'SL'){
											$SL++;
											$total_leave++;
										}elseif(isset($val['code']) && $val['code'] == 'ML'){
											$ML++;
											$total_leave++;
										}elseif(isset($val['code']) && $val['code'] == 'HL'){
											$HL++;
											$total_leave++;
										}
						}
									echo '</td>';
					} else{
						$day_letters = date("D", strtotime($ext_year."-".$month."-".$vj)) ; 
						if(!is_array($weekly_off1))
							$weekly_off1=array($weekly_off1);
						if( in_array($day_letters, $weekly_off1))								
							echo '<td style="background: #fed;"> '._("OFF").' </td>';
						else
							echo '<td> </td>';
					}
				}
			
			}elseif($payroll_monthly_choice == 3){
				$beginDay = date("Y-m-d", strtotime($ext_year."-".$pre_mnth."-".$kv_begin_days));

				$job_row  = GetRow('kv_empl_job', array('empl_id'=>$empl_id));			
						$weekly_off1 = $job_row['weekly_off'];

				$sql = "SELECT * FROM ".TB_PREF."kv_empl_attendance WHERE empl_id=".db_escape($empl_id)." AND a_date >= '".$beginDay."' AND a_date <= '".date("Y-m-t", strtotime($ext_year."-".$month."-01"))."' GROUP BY a_date, dimension ORDER BY a_date ASC";
				$res = db_query($sql, _("Can't get attendance"));
				$final = array();
				while($row2 = db_fetch_assoc($res)){
					$final[$row2['a_date']][$row2['dimension']] = $row2;
				}	
				$workingDays =	$pre_mnth = 0 ;
				if($hrmsetup['BeginDay'] >= 1 && $hrmsetup['BeginDay'] < 31){
						$kv_begin_days = $hrmsetup['BeginDay'];
					$pre_mnth =  (($month > 1)? ($month-1) : 12);
					if($pre_mnth == 12 )
							$prev_ext_year = $ext_year-1;
						else
							$prev_ext_year = $ext_year;

					$total_days =  date("t", strtotime($prev_ext_year."-".$pre_mnth."-01"));

					$beginDay = date("Y-m-d", strtotime($prev_ext_year."-".$pre_mnth."-".$kv_begin_days));
					$endDay	= 	date("Y-m-d", strtotime($prev_ext_year."-".$pre_mnth."-".$total_days));	
				}

				for($vj=$kv_begin_days; $vj <= 31; $vj++){	
					if(isset($final[date("Y-m-d", strtotime($prev_ext_year."-".$pre_mnth."-".$vj))])){
						echo '<td>';
						foreach($final[date("Y-m-d", strtotime($prev_ext_year."-".$pre_mnth."-".$vj))] as $dim => $val){
										$datee = $final[date("Y-m-d", strtotime($prev_ext_year."-".$pre_mnth."-".$vj))] ;
										// echo $val['code'].'<span>'.($val['code'] == 'P' : '') .'</span>';
										echo (isset($val['code']) ? $val['code'] : '-');
											if(isset($val['code']) && $val['code'] == 'P')
												$workingDays++;
											elseif(isset($val['code']) && $val['code'] == 'A')
												$leaveDays++;
											elseif(isset($val['code']) && $val['code'] == 'AL'){
												$AL++;
												$total_leave++;
											}elseif(isset($val['code']) && $val['code'] == 'SL'){
												$SL++;
												$total_leave++;
											}elseif(isset($val['code']) && $val['code'] == 'ML'){
												$ML++;
												$total_leave++;
											}elseif(isset($val['code']) && $val['code'] == 'HL'){
												$HL++;
												$total_leave++;
											}
						}
									echo '</td>';
					} else{
						$day_letters = date("D", strtotime($prev_ext_year."-".$pre_mnth."-".$vj)) ; 
						if(!is_array($weekly_off1))
							$weekly_off1=array($weekly_off1);
						if( in_array($day_letters, $weekly_off1))								
							echo '<td style="background: #fed;"> '._("OFF").' </td>';
						else
							echo '<td> </td>';
						}
					} 

				for($vj=1; $vj <=$hrmsetup['EndDay']; $vj++){	
					if(isset($final[date("Y-m-d", strtotime($prev_ext_year."-".$month."-".$vj))])){
									echo '<td>';
						foreach($final[date("Y-m-d", strtotime($prev_ext_year."-".$month."-".$vj))] as $dim => $val){
							$datee = $final[date("Y-m-d", strtotime($prev_ext_year."-".$month."-".$vj))] ;
										// echo $val['code'].'<span>'.($val['code'] == 'P' : '') .'</span>';
							echo (isset($val['code']) ? $val['code'] : '-');

							if(isset($val['code']) && $val['code'] == 'P')
											$workingDays++;
							elseif(isset($val['code']) && $val['code'] == 'A')
											$leaveDays++;
										elseif(isset($val['code']) && $val['code'] == 'AL'){
											$AL++;
											$total_leave++;
										}elseif(isset($val['code']) && $val['code'] == 'SL'){
											$SL++;
											$total_leave++;
										}elseif(isset($val['code']) && $val['code'] == 'ML'){
											$ML++;
											$total_leave++;
										}elseif(isset($val['code']) && $val['code'] == 'HL'){
											$HL++;
											$total_leave++;
										}

						}
									echo '</td>';
					} else{
						$day_letters = date("D", strtotime($prev_ext_year."-".$month."-".$vj)) ; 
						if(!is_array($weekly_off1))
							$weekly_off1=array($weekly_off1);
						if( in_array($day_letters, $weekly_off1))								
							echo '<td style="background: #fed;"> '._("OFF").' </td>';
						else
							echo '<td> </td>';
					}
				}
			}		

			echo '<td>'.$workingDays.'</td></tr>';
		}
			$lastMonth = end($selected_empl);
			$lastMonth = key($lastMonth);								
			$monthLeft = 12 - $lastMonth ;
			//$ALEncashed = GetSingleValue('kv_empl_leave_encashment', 'payable_days', array('empl_id' => $empl_id, 'year' => get_post('attendance_year')));
			$ALleave = GetSingleValue('kv_empl_job', 'al', array('empl_id' => $empl_id))/12;
			//if($ALEncashed > 0 )
				//$ALAvailable = 12*$ALleave-$ALEncashed;
			//else
				$ALAvailable = 12*$ALleave;
			$ALPayable = $lastMonth*$ALleave ; //- $ALEncashed;
			$SLleave = GetSingleValue('kv_empl_job', 'sl', array('empl_id' => $empl_id))/12;
			$SLAvailable = $SLleave-$SL;
			$MLleave = GetSingleValue('kv_empl_job', 'ml', array('empl_id' => $empl_id))/12;
			$MLAvailable = $MLleave-$ML;
			
			end_table(1);
			br();
			echo '<center> <h3> '.("Key Statistics").' </h3> </center>';
			br();
			start_table(TABLESTYLE_NOBORDER, "width=70%");
				start_row();
					label_cell(_("Leaves").'<br><h2>'.$total_leave.'</h2>');
					label_cell(_("Absents").'<br><h2>'.$leaveDays.'</h2>');
					label_cell(_('AL').'<br><h2>'.$AL.'</h2>');
					label_cell(_('SL').'<br><h2>'.$SL.'</h2>');
					label_cell(_('ML').'<br><h2>'.$ML.'</h2>');					
										
				end_row();				
			/*	start_row();
					label_cell("<center><h3>"._("Available Leave")."</h3></center><br> <hr>", "colspan='10'");
				end_row();
			
			echo '<hr>';
						
				start_row();
					label_cell('AL Paid<br><h2>'.$ALEncashed.'</h2>');
					label_cell('AL Payable<br><h2>'.$ALPayable.'</h2>');
					label_cell('AL<br><h2>'.$ALAvailable.'</h2>');						
					label_cell('SL<br><h2>'.$SLAvailable.'</h2>');						
					label_cell('ML<br><h2>'.$MLAvailable.'</h2>');						
					label_cell('HL<br><h2>'.$HLAvailable.'</h2>');						
				end_row();*/
			end_table();			
	}else 
			display_notification(_("No data Exist for the selected Employee."));
}

//-----------------------------------------------------------------------------------------
function empl_payroll_data($empl_id){
	global $SysPrefs, $path_to_root, $Ajax;
	br();
	start_table();
		kv_fiscalyears_list_row(_("Fiscal Year:"), 'year', null, true);
		end_table();
		br();

	if(list_updated('year')){
		$Ajax->activate('Payroll');
	}
	div_start('Payroll');		
		
	$get_employees_list = get_emply_salary($empl_id, get_post('year'));
	if(!empty($get_employees_list)){
		
	start_table(TABLESTYLE);
    $th = array(_("Fiscal Year"),_("Month"));
    $grade = GetSingleValue('kv_empl_job', 'grade', array('empl_id' => $empl_id));
    $Allowance = kv_get_allowances(null, 0, $grade);
	$Earnings_colum_count = 2;
	foreach($Allowance as $single) {	
		if($single['type'] == 'Earnings'){
			$th[] = array($single['description'] , '#f9f2bb', '#FF9800');
			$Earnings_colum_count++;
		}
	}
	$th[] = array(_("OT"), '#f9f2bb', '#FF9800');
	$th[] = array(_("Other Allowance"), '#f9f2bb', '#FF9800');
	$Reim_colum_count = 0;
	foreach($Allowance as $single) {	
		if($single['type'] == 'Reimbursement'){
			$th[] = array($single['description'] , '#f9f2bb', '#FF9800');
			$Reim_colum_count++;
		}
	}
	$th[] = array(_("Gross Pay"), '#f9f2bb', '#FF9800');
	$ctc_colum_count = 0;
	foreach($Allowance as $single) {	
		if($single['type'] == 'Employer Contribution'){
			$th[] = array($single['description'] , 'rgba(156, 39, 176, 0.23)', '#9C27B0');
			$ctc_colum_count++;
		}
	}
	$Deductions_colum_count = 0;
	$th[] = array(_("CTC"), 'rgba(156, 39, 176, 0.23)', '#9C27B0');
	foreach($Allowance as $single) {	
		if($single['type'] == 'Deductions') {
			$th[] = array($single['description'] , '#fed', '#f55');
			$Deductions_colum_count++;
		}
	}
   	$th1 = array(array(_("LOP Days"), '#fed', '#f55'), array(_("LOP Amount") , '#fed', '#f55'), array(_("Misc.") , '#fed', '#f55'), array(_("Total Deduction") , '#fed', '#f55'),array(_("Net Salary"), '#B7DBC1' ,  '#107B0F'), _(" "), _(" "), _(" "));
   	$th_final = array_merge($th, $th1);

	start_row();
	foreach($th_final as $header){
		if(is_array($header)){
			echo '<td style="background:'.$header[1].';color:'.$header[2].'"> '.$header[0].'</td>';
		} else {
			echo '<td class="tableheader"> '.$header.'</td>';
		}
	}end_row();		
			
	$Total_gross = $total_net = 0; 
	foreach($get_employees_list as $data_for_empl) { 

		if($data_for_empl) {
			start_row();
			
			$fiscal_yr = get_fiscalyear($data_for_empl['year']); 
				$employee_leave_record = get_empl_attendance_for_month($data_for_empl['empl_id'], $data_for_empl['month'], $data_for_empl['year']);
				label_cell(sql2date($fiscal_yr['begin']).' - '.sql2date($fiscal_yr['end']));
				label_cell(date("F", strtotime("2016-".$data_for_empl['month']."-01")));				
					foreach($Allowance as $single) {	
						if($single['type'] == 'Earnings')
							label_cell($data_for_empl[$single['id']], '', 'kv_gross_amt');
					}
					label_cell($data_for_empl['ot_earnings'], '', 'kv_gross_amt');
					label_cell($data_for_empl['ot_other_allowance'], '', 'kv_gross_amt');
					foreach($Allowance as $single) {	
						if($single['type'] == 'Reimbursement')
							label_cell($data_for_empl[$single['id']], '','kv_gross_amt');
					}
					label_cell($data_for_empl['gross'], '','kv_gross_amt');
					$ctc = $data_for_empl['gross'];
					foreach($Allowance as $single) {	
						if($single['type'] == 'Employer Contribution'){
							label_cell($data_for_empl[$single['id']], '', 'kv_ctc_amt');
							$ctc += $data_for_empl[$single['id']];
						}
					}
					label_cell($ctc, '', 'kv_ctc_amt');
					$total_deduct = $data_for_empl['misc']+$data_for_empl['lop_amount']; 
					foreach($Allowance as $single) {	
						if($single['type'] == 'Deductions'){
							label_cell($data_for_empl[$single['id']], '', 'kv_ded_amt');
							$total_deduct += $data_for_empl[$single['id']];
						}
					}
					
					//label_cell($data_for_empl['adv_sal']);
					//label_cell($data_for_empl['loan'], '', 'kv_ded_amt');
					label_cell($employee_leave_record, '', 'kv_ded_amt');
					label_cell($data_for_empl['lop_amount'], '', 'kv_ded_amt');
					label_cell($data_for_empl['misc'], '', 'kv_ded_amt');					
					label_cell($total_deduct, '', 'kv_ded_amt');
					label_cell($data_for_empl['net_pay'], '', 'kv_net_amt');

					$Total_gross += $data_for_empl['gross'];
					$total_net += $data_for_empl['net_pay'];
					//label_cell($data_for_empl['other_deduction']);
					label_cell('<a href="'.$path_to_root.'/modules/ExtendedHRM/payslip.php?employee_id='.$data_for_empl['empl_id'].'&month='.$data_for_empl['month'].'&year='.$data_for_empl['year'].'" onclick="javascript:openWindow(this.href,this.target); return false;"  target="_blank" > <img src="'.$path_to_root.'/themes/default/images/gl.png" width="12" height="12" border="0" title="GL"></a>');
					label_cell('<a onclick="javascript:openWindow(this.href,this.target); return false;" href="'.$path_to_root.'/modules/ExtendedHRM/reports/rep802.php?PARAM_0='.$data_for_empl['year'].'&PARAM_1='.$data_for_empl['month'].'&PARAM_2='.$data_for_empl["empl_id"].'&rep_v=yes" target="_blank" class="printlink"> <img src="'.$path_to_root.'/themes/default/images/print.png" width="12" height="12" border="0" title="Print"> </a>');
					label_cell('<a onclick="javascript:openWindow(this.href,this.target); return false;" href="'.$path_to_root.'/modules/ExtendedHRM/reports/rep802.php?PARAM_0='.$data_for_empl['year'].'&PARAM_1='.$data_for_empl['month'].'&PARAM_2='.$data_for_empl["empl_id"].'&rep_v=yes&email=yes" class="printlink"> <img src="'.$path_to_root.'/modules/ExtendedHRM/images/email-icon.png" width="20" height="20" border="0" title="'._("Print").'"> </a>');
				end_row();
			}
		}
		start_row();
		$gross_colm_cnt = $Earnings_colum_count+$Reim_colum_count; 
		$net_colm_cnt = $Deductions_colum_count+$ctc_colum_count+3; 
		echo " <td colspan='".$gross_colm_cnt."'> </td> <td colspan='2'><strong>"._("Total Gross")."</strong></td><td><strong>".$Total_gross."</strong></td> ";
		echo "<td colspan='".$net_colm_cnt."' align='right'></td> <td colspan='2'><strong>"._("Total Net Salary")."</strong></td> <td><strong>". $total_net."</strong></td><td colspan='3'> </td>";
			
		end_row();		
    end_table(1);
	}else {
		display_notification(_("No data Exist for the selected Employee."));
	}
	div_end();
}
?>