<?php
/****************************************
/*  Author  : Kvvaradha
/*  Module  : Kvcodes CRM
/*  E-mail  : admin@kvcodes.com
/*  Version : 1.0
/*  Http    : www.kvcodes.com
*****************************************/
$page_security = 'SA_OPEN';
$path_to_root="../../..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/modules/ExtendedHRM/includes/kvcodes.inc" );
include_once($path_to_root . "/includes/ui.inc");
add_access_extensions();


$js ='';
page(_("Web Candidate Setup"), false, false, "", $js);
global $lead_options ;

//-------------------------------------------------------------------------------------------

$lead_options =array('form_name','btn_txt','success_txt','captcha_public_k','captcha_private_k');

//-------------------------------------------------------------------------------------------

function can_process(){
	$error =0;

	if(strlen(trim($_POST['form_name'])) ==0){
		display_error(_("Form name cannot be empty"));
		set_focus('form_name');
		$error =1;
	}
	if(strlen(trim($_POST['btn_txt'])) ==0){
		display_error(_("Submit button text cannot be empty"));
		set_focus('btn_txt');
		$error =1;
	}
	if(strlen(trim($_POST['success_txt'])) ==0){
		display_error(_("Success Message cannot be empty"));
		set_focus('success_txt');
		$error =1;
	}


	if($error ==1)
		return false;
	else
		return true;
}

//-------------------------------------------------------------------------------------------

if(isset($_POST['update_setup']) && can_process()){
	$update =array();
	foreach ($lead_options as $option) {
		$update[$option] =$_POST[$option];
	}
	Update('kv_empl_option',array('option_name'=>'web_candidate_options'),array('option_value'=>base64_encode(serialize($update))));
	$style_sheet_path =$path_to_root."/modules/ExtendedHRM/form/style.css";
	if(strlen(trim($_POST['description'])) ==0 ){
		if(file_exists($style_sheet_path)){
			unlink($style_sheet_path);
		}
	}else{
		$style_sheet = fopen($style_sheet_path, "w");
		fwrite($style_sheet, $_POST['description']);
		fclose($style_sheet);
	}
	display_notification(_("Web candidate setup has been updated successfully"));
}

//-------------------------------------------------------------------------------------------
function candidates_form_setup()
{
	global $lead_options,$path_to_root ;
	$style_sheet_path =$path_to_root."/modules/ExtendedHRM/form/style.css";
	if(file_exists($style_sheet_path)){
		$style_sheet = fopen($style_sheet_path, "r") or die("Unable to open file!");
		$_POST['description'] =fread($style_sheet,filesize($style_sheet_path));
		fclose($style_sheet);
	}else{
		$_POST['description'] ='';
	}
	$row = GetSingleValue('kv_empl_option','option_value',array('option_name'=>'web_candidate_options'));

	if($row && is_array($row)){
		foreach ($lead_options as $option) {
			if(!isset($_POST[$option])){
				if(isset($row[$option]))
					$_POST[$option] =$row[$option];
				else
					$_POST[$option] ='';
			}
		}
	}
	br();
	start_outer_table(TABLESTYLE2);

	table_section(1);
	table_section_title(_("Setups"));
	text_row(_("Form Name"), "form_name", null ,20, 50);
	text_row(_("Submit Button Text"), "btn_txt",null, 20, 50);
	textarea_row(_("Success Message"), 'success_txt', null, 30, 8);
	textarea_row(_("Additional CSS"), 'description', null, 30, 8);


	table_section(2);
	table_section_title(_("Captcha Setup"));
	text_row(_("Public Key"), "captcha_public_k", null ,20, 150);
	text_row(_("Private Key"), "captcha_private_k",null, 20, 150);
	end_outer_table(1);

	submit_center( 'update_setup', _('Update'), true, '',  'default');
}

function candidates_integration_code(){
	br();
	display_note(_("Copy & Paste the code anywhere in your site to show the form, addtionally you can width and height px to fix your website").".");


		$protocol = strtolower(substr($_SERVER["SERVER_PROTOCOL"],0,5)) == 'https://' ? 'https://' : 'http://';
	    $fa_url= $protocol.$_SERVER['SERVER_NAME'].dirname($_SERVER['PHP_SELF']);
	    $pos = strpos($fa_url, '/modules/ExtendedHRM/');
	    $base_url =  substr($fa_url, 0, $pos);
	    start_table();

	    $encoded_company_id = base64_encode(serialize($_SESSION['wa_current_user']->company));

	    $lead_url =$base_url.'/modules/ExtendedHRM/form/?id='.$encoded_company_id;

	    display_note('<pre>'.$lead_url.' </pre>');
	    display_note('<pre>'.htmlspecialchars('<iframe width="600" height="850" src="'.$lead_url.'" frameborder="0" allowfullscreen> </iframe>').' </pre>');
	    end_table();

}
//-------------------------------------------------------------------------------------------

start_form(true);

$tabs_ar = array(
		'setup' => array(_('&Setup'),true),
		'integration' => array(_('&Integration Code'),true),
	); 

tabbed_content_start('tabs', $tabs_ar);
	
	switch (get_post('_tabs_sel')) {
		default:
		case 'setup':
			candidates_form_setup(); 
			break;
		case 'integration':
			candidates_integration_code();
			break;
	};
br();
tabbed_content_end();

end_form();
end_page();
?>