# Module name : Kvcodes CRM
# Module Author : Kvvaradha
# http://www.kvcodes.com
# Company: Kvcodes CRM
# User : Administrator
# Compatibility: 2.4.6

SET SQL_MODE='';



DROP TABLE IF EXISTS 0_email_log;

CREATE TABLE IF NOT EXISTS  `0_email_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `email` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `slug` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `subject` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `error` text COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '0- Not Send, 1-Send',
  `date_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY(`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


CREATE TABLE IF NOT EXISTS `0_custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `module` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `field_name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `pick_type` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `header_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `custom_fields`
--

-- --------------------------------------------------------

--
-- Table structure for table `custom_headers`
--

CREATE TABLE IF NOT EXISTS `0_custom_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `header_label` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `module` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `position` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

DROP TABLE IF EXISTS 0_kv_crm_tickets;
-- --------------------------------------------------------
CREATE TABLE `0_kv_crm_tickets` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `master_id` int(11) NOT NULL,
  `from_user_type` int(5) NOT NULL DEFAULT '0',
  `to_user_type` int(20) NOT NULL DEFAULT '0',
  `to` int(25) NOT NULL,
  `subject` text NOT NULL,
  `message` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL,
  `type_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- --------------------------------------------------------
DROP TABLE IF EXISTS 0_kv_crm_tickets_replies;
-- --------------------------------------------------------
CREATE TABLE `0_kv_crm_tickets_replies` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) NOT NULL,
  `comment` text NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `date` datetime DEFAULT NULL,
  `from` int(11) NOT NULL,
  `from_user_type` int(5) NOT NULL,
  `to` int(11) NOT NULL,
  `replies` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#------------------------------------------------------------------------------------
    ### Structure of table `kv_crm_activities` ### 

 DROP TABLE IF EXISTS 0_kv_crm_activities;

CREATE TABLE `0_kv_crm_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL,
  `type_id` int(11) NOT NULL,
  `name` varchar(350) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `medium` tinyint(1) NOT NULL,
  `date` date NOT NULL,
  `reminder_date` date NOT NULL,
  `medium_to` tinyint(1) NOT NULL,
  `alert` tinyint(1) NOT NULL,
  `user` int(11) NOT NULL,
  `status` int(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_attachments` ### 

 DROP TABLE IF EXISTS 0_kv_crm_attachments;

CREATE TABLE `0_kv_crm_attachments` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL,
  `type_id` varchar(10) NOT NULL,
  `title` varchar(60) NOT NULL,
  `filename` varchar(600) NOT NULL,
  `filesize` int(11) NOT NULL,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  `date` date NOT NULL,
  `unique_name` varchar(60) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_comments` ### 

 DROP TABLE IF EXISTS 0_kv_crm_comments;

CREATE TABLE `0_kv_crm_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL,
  `type_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `status` int(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_country` ### 

 DROP TABLE IF EXISTS 0_kv_crm_country;

CREATE TABLE `0_kv_crm_country` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `iso` varchar(50) DEFAULT NULL,
  `local_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=249 DEFAULT CHARSET=utf8;

INSERT INTO 0_kv_crm_country VALUES("1","AD","Andorra"),
 ("2","AE","United Arab Emirates"),
 ("3","AF","Afghanistan"),
 ("4","AG","Antigua and Barbuda"),
 ("5","AI","Anguilla"),
 ("6","AL","Albania"),
 ("7","AM","Armenia"),
 ("8","AN","Netherlands Antilles"),
 ("9","AO","Angola"),
 ("10","AQ","Antarctica"),
 ("11","AR","Argentina"),
 ("12","AS","American Samoa"),
 ("13","AT","Austria"),
 ("14","AU","Australia"),
 ("15","AW","Aruba"),
 ("16","AX","Aland Islands"),
 ("17","AZ","Azerbaijan"),
 ("18","BA","Bosnia and Herzegovina"),
 ("19","BB","Barbados"),
 ("20","BD","Bangladesh"),
 ("21","BE","Belgium"),
 ("22","BF","Burkina Faso"),
 ("23","BG","Bulgaria"),
 ("24","BH","Bahrain"),
 ("25","BI","Burundi"),
 ("26","BJ","Benin"),
 ("27","BL","Saint Barthlemy"),
 ("28","BM","Bermuda"),
 ("29","BN","Brunei Darussalam"),
 ("30","BO","BoliviaBolivia, Plurinational state of"),
 ("31","BR","Brazil"),
 ("32","BS","Bahamas"),
 ("33","BT","Bhutan"),
 ("34","BV","Bouvet Island"),
 ("35","BW","Botswana"),
 ("36","BY","Belarus"),
 ("37","BZ","Belize"),
 ("38","CA","Canada"),
 ("39","CC","Cocos (Keeling) Islands"),
 ("40","CD","Congo, The Democratic Republic of the"),
 ("41","CF","Central African Republic"),
 ("42","CG","Congo"),
 ("43","CH","Switzerland"),
 ("45","CK","Cook Islands"),
 ("46","CL","Chile"),
 ("47","CM","Cameroon"),
 ("48","CN","China"),
 ("49","CO","Colombia"),
 ("50","CR","Costa Rica"),
 ("51","CU","Cuba"),
 ("52","CV","Cape Verde"),
 ("53","CX","Christmas Island"),
 ("54","CY","Cyprus"),
 ("55","CZ","Czech Republic"),
 ("56","DE","Germany"),
 ("57","DJ","Djibouti"),
 ("58","DK","Denmark"),
 ("59","DM","Dominica"),
 ("60","DO","Dominican Republic"),
 ("61","DZ","Algeria"),
 ("62","EC","Ecuador"),
 ("63","EE","Estonia"),
 ("64","EG","Egypt"),
 ("65","EH","Western Sahara"),
 ("66","ER","Eritrea"),
 ("67","ES","Spain"),
 ("68","ET","Ethiopia"),
 ("69","FI","Finland"),
 ("70","FJ","Fiji"),
 ("71","FK","Falkland Islands (Malvinas)"),
 ("72","FM","Micronesia, Federated States of"),
 ("73","FO","Faroe Islands"),
 ("74","FR","France"),
 ("75","GA","Gabon"),
 ("76","GB","United Kingdom"),
 ("77","GD","Grenada"),
 ("78","GE","Georgia"),
 ("79","GF","French Guiana"),
 ("80","GG","Guernsey"),
 ("81","GH","Ghana"),
 ("82","GI","Gibraltar"),
 ("83","GL","Greenland"),
 ("84","GM","Gambia"),
 ("85","GN","Guinea"),
 ("86","GP","Guadeloupe"),
 ("87","GQ","Equatorial Guinea"),
 ("88","GR","Greece"),
 ("89","GS","South Georgia and the South Sandwich Islands"),
 ("90","GT","Guatemala"),
 ("91","GU","Guam"),
 ("92","GW","Guinea-Bissau"),
 ("93","GY","Guyana"),
 ("94","HK","Hong Kong"),
 ("95","HM","Heard Island and McDonald Islands"),
 ("96","HN","Honduras"),
 ("97","HR","Croatia"),
 ("98","HT","Haiti"),
 ("99","HU","Hungary"),
 ("100","ID","Indonesia"),
 ("101","IE","Ireland"),
 ("102","IL","Israel"); 
INSERT INTO 0_kv_crm_country VALUES("103","IM","Isle of Man"),
 ("104","IN","India"),
 ("105","IO","British Indian Ocean Territory"),
 ("106","IQ","Iraq"),
 ("107","IR","Iran, Islamic Republic of"),
 ("108","IS","Iceland"),
 ("109","IT","Italy"),
 ("110","JE","Jersey"),
 ("111","JM","Jamaica"),
 ("112","JO","Jordan"),
 ("113","JP","Japan"),
 ("114","KE","Kenya"),
 ("115","KG","Kyrgyzstan"),
 ("116","KH","Cambodia"),
 ("117","KI","Kiribati"),
 ("118","KM","Comoros"),
 ("119","KN","Saint Kitts and Nevis"),
 ("120","KP","Korea, Democratic People&#039;s Republic of"),
 ("121","KR","Korea, Republic of"),
 ("122","KW","Kuwait"),
 ("123","KY","Cayman Islands"),
 ("124","KZ","Kazakhstan"),
 ("125","LA","Lao People&#039;s Democratic Republic"),
 ("126","LB","Lebanon"),
 ("127","LC","Saint Lucia"),
 ("128","LI","Liechtenstein"),
 ("129","LK","Sri Lanka"),
 ("130","LR","Liberia"),
 ("131","LS","Lesotho"),
 ("132","LT","Lithuania"),
 ("133","LU","Luxembourg"),
 ("134","LV","Latvia"),
 ("135","LY","Libyan Arab Jamahiriya"),
 ("136","MA","Morocco"),
 ("137","MC","Monaco"),
 ("138","MD","Moldova, Republic of"),
 ("139","ME","Montenegro"),
 ("140","MF","Saint Martin"),
 ("141","MG","Madagascar"),
 ("142","MH","Marshall Islands"),
 ("143","MK","Macedonia"),
 ("144","ML","Mali"),
 ("145","MM","Myanmar"),
 ("146","MN","Mongolia"),
 ("147","MO","Macao"),
 ("148","MP","Northern Mariana Islands"),
 ("149","MQ","Martinique"),
 ("150","MR","Mauritania"),
 ("151","MS","Montserrat"),
 ("152","MT","Malta"),
 ("153","MU","Mauritius"),
 ("154","MV","Maldives"),
 ("155","MW","Malawi"),
 ("156","MX","Mexico"),
 ("157","MY","Malaysia"),
 ("158","MZ","Mozambique"),
 ("159","NA","Namibia"),
 ("160","NC","New Caledonia"),
 ("161","NE","Niger"),
 ("162","NF","Norfolk Island"),
 ("163","NG","Nigeria"),
 ("164","NI","Nicaragua"),
 ("165","NL","Netherlands"),
 ("166","NO","Norway"),
 ("167","NP","Nepal"),
 ("168","NR","Nauru"),
 ("169","NU","Niue"),
 ("170","NZ","New Zealand"),
 ("171","OM","Oman"),
 ("172","PA","Panama"),
 ("173","PE","Peru"),
 ("174","PF","French Polynesia"),
 ("175","PG","Papua New Guinea"),
 ("176","PH","Philippines"),
 ("177","PK","Pakistan"),
 ("178","PL","Poland"),
 ("179","PM","Saint Pierre and Miquelon"),
 ("180","PN","Pitcairn"),
 ("181","PR","Puerto Rico"),
 ("182","PS","Palestinian Territory, Occupied"),
 ("183","PT","Portugal"),
 ("184","PW","Palau"),
 ("185","PY","Paraguay"),
 ("186","QA","Qatar"),
 ("188","RO","Romania"),
 ("189","RS","Serbia"),
 ("190","RU","Russian Federation"),
 ("191","RW","Rwanda"),
 ("192","SA","Saudi Arabia"),
 ("193","SB","Solomon Islands"),
 ("194","SC","Seychelles"),
 ("195","SD","Sudan"),
 ("196","SE","Sweden"),
 ("197","SG","Singapore"),
 ("198","SH","Saint Helena"),
 ("199","SI","Slovenia"),
 ("200","SJ","Svalbard and Jan Mayen"),
 ("201","SK","Slovakia"),
 ("202","SL","Sierra Leone"),
 ("203","SM","San Marino"),
 ("204","SN","Senegal"); 
INSERT INTO 0_kv_crm_country VALUES("205","SO","Somalia"),
 ("206","SR","Suriname"),
 ("207","ST","Sao Tome and Principe"),
 ("208","SV","El Salvador"),
 ("209","SY","Syrian Arab Republic"),
 ("210","SZ","Swaziland"),
 ("211","TC","Turks and Caicos Islands"),
 ("212","TD","Chad"),
 ("213","TF","French Southern Territories"),
 ("214","TG","Togo"),
 ("215","TH","Thailand"),
 ("216","TJ","Tajikistan"),
 ("217","TK","Tokelau"),
 ("218","TL","Timor-Leste"),
 ("219","TM","Turkmenistan"),
 ("220","TN","Tunisia"),
 ("221","TO","Tonga"),
 ("222","TR","Turkey"),
 ("223","TT","Trinidad and Tobago"),
 ("224","TV","Tuvalu"),
 ("225","TW","Taiwan"),
 ("226","TZ","Tanzania, United Republic of"),
 ("227","UA","Ukraine"),
 ("228","UG","Uganda"),
 ("229","UM","United States Minor Outlying Islands"),
 ("230","US","United States"),
 ("231","UY","Uruguay"),
 ("232","UZ","Uzbekistan"),
 ("233","VA","Holy See (Vatican City State)"),
 ("234","VC","Saint Vincent and the Grenadines"),
 ("235","VE","Venezuela, Bolivarian Republic of"),
 ("236","VG","Virgin Islands, British"),
 ("237","VI","Virgin Islands, U.S."),
 ("238","VN","Viet Nam"),
 ("239","VU","Vanuatu"),
 ("240","WF","Wallis and Futuna"),
 ("241","WS","Samoa"),
 ("242","YE","Yemen"),
 ("243","YT","Mayotte"),
 ("244","ZA","South Africa"),
 ("245","ZM","Zambia"),
 ("246","ZW","Zimbabwe"),
 ("247","","Other"),
 ("248",""," Tamil  Nadu ");

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_email_templates` ### 

 DROP TABLE IF EXISTS 0_kv_crm_email_templates;

CREATE TABLE `0_kv_crm_email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(5) NOT NULL,
  `slug` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `name` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `subject` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO 0_kv_crm_email_templates VALUES("1","3","new-client-created","New Contact Added/Registered (Welcome Email)","Welcome aboard","Dear {contact_firstname} {contact_lastname}&lt;br&gt;&lt;br&gt;Thank you for registering on the &lt;strong&gt;{coy_name}&lt;/strong&gt; CRM System.&lt;br&gt; &lt;br&gt;We just wanted to say welcome.&lt;br&gt; &lt;br&gt;Please contact us if you need any help.&lt;br&gt; &lt;br&gt;Click here to view your profile: &lt;a href=\"{crm_url}\"&gt;{crm_url}&lt;/a&gt;User Name: &lt;a href=\"{user_name}\"&gt;{user}&lt;/a&gt;Password: &lt;a href=\"{password}\"&gt;{password}&lt;/a&gt;&lt;br&gt; &lt;br&gt;Kind Regards, &lt;br&gt;{email_signature}&lt;br&gt; &lt;br&gt;(This is an automated email, so please don&#039;t reply to this email address)","0"),
 ("2","7","invoice-send-to-client","Send Invoice to Customer","Invoice with number {invoice_number} created","<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\">We have prepared the following invoice for you: <strong># {invoice_number}</strong></span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Invoice status</strong>: {invoice_status}</span><br /> <br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("3","15","new-ticket-opened-admin","New Ticket Opened (Opened by Staff, Sent to Customer)","New Support Ticket Opened","<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\">New support ticket has been opened.</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department:</strong> {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {ticket_priority}</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}<br /><br /></a>Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("4","15","ticket-reply","Ticket Reply (Sent to Customer)","New Ticket Reply","<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\">You have a new ticket reply to ticket <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Ticket Subject:</strong> {ticket_subject}</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("5","15","ticket-autoresponse","New Ticket Opened - Autoresponse","New Support Ticket Opened","<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Thank you for contacting our support team. A support ticket has now been opened for your request. You will be notified when a response is made by email.</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Subject:</strong> {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {ticket_priority}</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("6","7","invoice-payment-recorded","Invoice Payment Recorded (Sent to Customer)","Invoice Payment Recorded","<span style=\"font-size: 12pt;\">Hi&nbsp;{contact_firstname}&nbsp;{contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Payment recorded for invoice <strong># {invoice_number}</strong></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("7","7","invoice-overdue-notice","Invoice Overdue Notice","Invoice Overdue Notice - {invoice_number}","<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\">This is an overdue notice for invoice <strong># {invoice_number}</strong></span><br /> <br /><span style=\"font-size: 12pt;\">This invoice was due: {invoice_duedate}</span><br /> <br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("8","7","invoice-already-send","Invoice Already Sent to Customer","On your command here is the invoice","<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\">At your request, here is the invoice with number <strong># {invoice_number}</strong></span><br /> <br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("9","15","new-ticket-created-staff","New Ticket Created (Opened by Customer, Sent to Staff Members)","New Ticket Created","<span style=\"font-size: 12pt;\">A new support ticket has been opened.</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Subject</strong>: {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority</strong>: {ticket_priority}</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /><br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}<br /></a></span><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("10","33","estimate-send-to-client","Send Estimate to Customer","Estimate # {estimate_number} created","&lt;span style=\"font-size: 12pt;\"&gt;Dear {contact_firstname} {contact_lastname}&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;Please find the attached estimate &lt;strong&gt;# {estimate_number}&lt;/strong&gt;&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;You can contact me for further details of this estimate.&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;We look forward to your communication.&lt;/span&gt;&lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;&lt;br&gt;&lt;/span&gt;","0"),
 ("11","15","ticket-reply-to-admin","Ticket Reply (Sent to Staff)","New Support Ticket Reply","<span style=\"font-size: 12pt;\">A new support ticket reply from {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Subject</strong>: {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority</strong>: {ticket_priority}</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /> <br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("12","33","estimate-already-send","Estimate Already Sent to Customer","Estimate # {estimate_number} ","&lt;span style=\"font-size: 12pt;\"&gt;Dear {contact_firstname} {contact_lastname}&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;Thank you for your estimate request.&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 16px;\"&gt;You can contact me for further details of this estimate.&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;Please contact us for more information.&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;Kind Regards,&lt;/span&gt;&lt;br&gt;","0"),
 ("14","5","task-assigned","New Task Assigned (Sent to Staff)","New Task Assigned to You - {task_name}","<span style=\"font-size: 12pt;\">Dear {staff_firstname} {staff_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\">You have been assigned to a new task:</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}<br /></span><strong>Start Date:</strong> {task_startdate}<br /><span style=\"font-size: 12pt;\"><strong>Due date:</strong> {task_duedate}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {task_priority}<br /></span><br /><span style=\"font-size: 12pt;\"><span>You can view the task on the following link</span>: <a href=\"{task_link}\">{task_name}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("16","5","task-commented","New Comment on Task (Sent to Staff)","New Comment on Task - {task_name}","Dear {staff_firstname} {staff_lastname}<br /> <br />A comment has been made on the following task:<br /> <br /><strong>Name:</strong> {task_name}<br /><strong>Comment:</strong> {task_comment}<br /><br />You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a><br /> <br />Kind Regards,<br />{email_signature}","0"),
 ("18","33","estimate-declined-to-staff","Estimate Declined (Sent to Staff)","Customer Declined Estimate","<span style=\"font-size: 12pt;\">Hi</span><br /> <br /><span style=\"font-size: 12pt;\">Customer ({client_company}) declined estimate with number <strong># {estimate_number}</strong></span><br /> <br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("19","33","estimate-accepted-to-staff","Estimate Accepted (Sent to Staff)","Customer Accepted Estimate","<span style=\"font-size: 12pt;\">Hi</span><br /> <br /><span style=\"font-size: 12pt;\">Customer ({client_company}) accepted estimate with number <strong># {estimate_number}</strong></span><br /> <br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("20","34","proposal-client-accepted","Customer Action - Accepted (Sent to Staff)","Customer Accepted Proposal","<div>Hi<br /> <br />Client <strong>{proposal_proposal_to}</strong> accepted the following proposal:<br /> <br /><strong>Number:</strong> {proposal_number}<br /><strong>Subject</strong>: {proposal_subject}<br /><strong>Total</strong>: {proposal_total}<br /> <br />View the proposal on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /> <br />Kind Regards,<br />{email_signature}</div>
\n<div>&nbsp;</div>
\n<div>&nbsp;</div>
\n<div>&nbsp;</div>","0"),
 ("21","34","proposal-send-to-customer","Send Proposal to Customer","Proposal With Number {proposal_number} Created","Dear {proposal_proposal_to}<br /> <br />Please find our attached proposal.<br /> <br />This proposal is valid until: {proposal_open_till}<br />You can view the proposal on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /> <br />Please don\'t hesitate to comment online if you have any questions.<br /> <br />We look forward to your communication.<br /> <br />Kind Regards,<br />{email_signature}","0"),
 ("22","34","proposal-client-declined","Customer Action - Declined (Sent to Staff)","Client Declined Proposal","Hi<br /> <br />Customer <strong>{proposal_proposal_to}</strong> declined the proposal <strong>{proposal_subject}</strong><br /> <br />View the proposal on the following link <a href=\"{proposal_link}\">{proposal_number}</a>&nbsp;or from the admin area.<br /> <br />Kind Regards,<br />{email_signature}","0"),
 ("23","34","proposal-client-thank-you","Thank You Email (Sent to Customer After Accept)","Thank for you accepting proposal","Dear {proposal_proposal_to}<br /> <br />Thank for for accepting the proposal.<br /> <br />We look forward to doing business with you.<br /> <br />We will contact you as soon as possible<br /> <br />Kind Regards,<br />{email_signature}","0"),
 ("24","34","proposal-comment-to-client","New Comment  (Sent to Customer/Lead)","New Proposal Comment","Dear {proposal_proposal_to}<br /> <br />A new comment has been made on the following proposal: <strong>{proposal_number}</strong><br /> <br />You can view and reply to the comment on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /> <br />Kind Regards,<br />{email_signature}","0"),
 ("25","34","proposal-comment-to-admin","New Comment (Sent to Staff) ","New Proposal Comment","Hi<br /> <br />A new comment has been made to the proposal <strong>{proposal_subject}</strong><br /> <br />You can view and reply to the comment on the following link: <a href=\"{proposal_link}\">{proposal_number}</a>&nbsp;or from the admin area.<br /> <br />{email_signature}","0"),
 ("26","33","estimate-thank-you-to-customer","Thank You Email (Sent to Customer After Accept)","Thank for you accepting estimate","<span style=\"font-size: 12pt;\">Dear {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\">Thank for for accepting the estimate.</span><br /> <br /><span style=\"font-size: 12pt;\">We look forward to doing business with you.</span><br /> <br /><span style=\"font-size: 12pt;\">We will contact you as soon as possible.</span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("27","5","task-deadline-notification","Task Deadline Reminder - Sent to Assigned Members","Task Deadline Reminder","Hi {staff_firstname}&nbsp;{staff_lastname}<br /> <br />This is an automated email from {companyname}.<br /><br />The task <strong>{task_name}</strong> deadline is on <strong>{task_duedate}</strong>. <br />This task is still not finished.<br /> <br />You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a><br /><br />Kind Regards,<br />{email_signature}","0"),
 ("29","7","invoice-payment-recorded-to-staff","Invoice Payment Recorded (Sent to Staff)","New Invoice Payment","<span style=\"font-size: 12pt;\">Hi</span><br /><br /><span style=\"font-size: 12pt;\">Customer recorded payment for invoice <strong># {invoice_number}</strong></span><br /> <br /><span style=\"font-size: 12pt;\">You can view the invoice on the following link: <a href=\"{invoice_link}\">{invoice_number}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("30","15","auto-close-ticket","Auto Close Ticket","Ticket Auto Closed","<p><span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /><br /><span style=\"font-size: 12pt;\">Ticket {ticket_subject} has been auto close due to inactivity.</span><br /><br /><span style=\"font-size: 12pt;\"><strong>Ticket #</strong>: <a href=\"{ticket_url}\">{ticket_id}</a></span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority:</strong> {ticket_priority}</span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>","0"),
 ("33","13","new-uploaded-to-customer","New Project File(s) Uploaded (Sent to Customer Contacts)","New Project File(s) Uploaded","<p>Hello {contact_firstname} {contact_lastname}<br /><br />New project file is uploaded on <strong>{project_name}</strong> from <strong>{file_creator}</strong><br /><br />You can view the project on the following link: <a href=\"{project_link}\">{project_name}</a><br /><br />To view the file in our CRM you can click on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a><br /><br />Kind Regards,<br />{email_signature}</p>","0"),
 ("34","13","new-uploaded-to-staff","New Project File(s) Uploaded (Sent to Project Members)","New Project File(s) Uploaded","<p>Hello&nbsp;{staff_firstname}&nbsp;{staff_lastname}</p>
\n<p>New project&nbsp;file is uploaded on&nbsp;<strong>{project_name}</strong> from&nbsp;<strong>{file_creator}</strong></p>
\n<p>You can view the project on the following link: <a href=\"{project_link}\">{project_name}<br /></a><br />To view&nbsp;the file you can click on the following link: <a href=\"{discussion_link}\">{discussion_subject}</a></p>
\n<p>Kind Regards,<br />{email_signature}</p>","0"),
 ("35","12","new-comment-to-customer","New Comment  (Sent to Customer Contacts)","New Comment","&lt;p&gt;&lt;span style=\"font-size: 12pt;\"&gt;Hello {contact_firstname} {contact_lastname}&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;New discussion comment has been made on &lt;strong&gt;{discussion_subject}&lt;/strong&gt; from &lt;strong&gt;{comment_creator}&lt;/strong&gt;&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;&lt;strong&gt;Discussion subject:&lt;/strong&gt; {discussion_subject}&lt;/span&gt;&lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;&lt;strong&gt;Comment&lt;/strong&gt;: {discussion_comment}&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;You can view the discussion on the following link: &lt;a href=\"{discussion_link}\"&gt;{discussion_subject}&lt;/a&gt;&lt;/span&gt;&lt;br&gt;&lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;Kind Regards,&lt;/span&gt;&lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;{email_signature}&lt;/span&gt;&lt;/p&gt;","0"),
 ("36","12","new-comment-to-staff","New Comment (Sent to Project Members)","New Comment","&lt;p&gt;Hello {staff_firstname} {staff_lastname}&lt;br&gt;&lt;br&gt;New discussion comment has been made on &lt;strong&gt;{discussion_subject}&lt;/strong&gt; from &lt;strong&gt;{comment_creator}&lt;/strong&gt;&lt;br&gt;&lt;br&gt;&lt;strong&gt;Discussion subject:&lt;/strong&gt; {discussion_subject}&lt;br&gt;&lt;strong&gt;Comment:&lt;/strong&gt; {discussion_comment}&lt;br&gt;&lt;br&gt;You can view the discussion on the following link: &lt;a href=\"{discussion_link}\"&gt;{discussion_subject}&lt;/a&gt;&lt;br&gt;&lt;br&gt;Kind Regards,&lt;br&gt;{email_signature}&lt;/p&gt;","0"),
 ("37","2","staff-added-as-project-member","Staff Added as Project Member","New project assigned to you","<p>Hello {staff_firstname} {staff_lastname}<br /><br />New project has been assigned to you.<br /><br />You can view the project on the following link <a href=\"{project_link}\">{project_name}</a><br /><br />{email_signature}</p>","0"),
 ("38","33","estimate-expiry-reminder","Estimate Expiration Reminder","Estimate Expiration Reminder","<p><span style=\"font-size: 12pt;\">Hello {client_company}</span><br /><br /><span style=\"font-size: 12pt;\">The estimate with <strong># {estimate_number}</strong> will expire on <strong>{estimate_expirydate}</strong></span><br /><br /><span style=\"font-size: 12pt;\">You can view the estimate on the following link: <a href=\"{estimate_link}\">{estimate_number}</a></span><br /><br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>","0"),
 ("39","34","proposal-expiry-reminder","Proposal Expiration Reminder","Proposal Expiration Reminder","<p>Hello {proposal_proposal_to}<br /><br />The proposal {proposal_number}&nbsp;will expire on <strong>{proposal_open_till}</strong><br /><br />You can view the proposal on the following link: <a href=\"{proposal_link}\">{proposal_number}</a><br /><br />Kind Regards,<br />{email_signature}</p>","0"),
 ("40","11","new-staff-created","New Staff Created (Welcome Email)","You are added as staff member","Hello {staff_fullname}&amp;nbsp;&lt;br&gt;You are added as member on our CRM.&lt;br&gt;&lt;br&gt;Please use the following logic credentials:&lt;br&gt;&lt;br&gt;&lt;strong&gt;Email:&lt;/strong&gt; {staff_email}&lt;br&gt;&lt;strong&gt;Password:&lt;/strong&gt; {password}&lt;br&gt;&lt;br&gt;Click &lt;a href=\"{fa_url}\" title=\"\" target=\"\"&gt;here &lt;/a&gt;to login in the {coy_name}.&lt;br&gt;&lt;br&gt;Best Regards,&lt;br&gt;","0"),
 ("42","3","contact-password-reseted","Password Reset - Confirmation","Your password has been changed","&lt;strong&gt;&lt;span style=\"font-size: 14pt;\"&gt;You have changed your password.&lt;/span&gt;&lt;br&gt;&lt;/strong&gt;&lt;br&gt; Please, keep it in your records so you don&#039;t forget it.&lt;br&gt; &lt;br&gt; Your new password for login is: {login_password}&lt;br&gt;&lt;br&gt;If this wasnt you, please contact us.&lt;br&gt;&lt;br&gt;{email_signature}","0"),
 ("44","11","staff-forgot-password","Forgot Password","Create New Password","&lt;h2&gt;&lt;span style=\"font-size: 14pt;\"&gt;Create a new password&lt;/span&gt;&lt;/h2&gt;\nForgot your password?&lt;br&gt; To create a new password, just follow this link:&lt;br&gt; &lt;br&gt;&lt;a href=\"{reset_url}\" title=\"\" target=\"\"&gt;Reset Password&lt;/a&gt;&lt;br&gt; &lt;br&gt; You received this email, because it was requested by a &lt;strong&gt;{companyname}&lt;/strong&gt;&amp;nbsp;user. This is part of the procedure to create a new password on the system. If you DID NOT request a new password then please ignore this email and your password will remain the same. &lt;br&gt;&lt;br&gt;Regards,&amp;nbsp;","1"),
 ("45","11","staff-password-reseted","Password Reset - Confirmation","Your password has been changed","&lt;span style=\"font-size: 14pt;\"&gt;&lt;strong&gt;Your Password has been changed.&lt;/strong&gt;&lt;/span&gt;&lt;div&gt;&lt;span style=\"font-size: 14pt;\"&gt;&lt;strong&gt;&lt;br&gt;&lt;/strong&gt;&lt;/span&gt;Hello {staff_fullname},&lt;div&gt;&amp;nbsp;Please, keep it in your records so you don&#039;t forget it.&lt;br&gt; &lt;br&gt; Your email address for login is: {staff_email}&lt;div&gt;Your New Password : {password}&lt;br&gt;&lt;br&gt; If this wasnt you, please contact us. Or you can use this password and login and than change the password again back to yours.&lt;br&gt;&lt;br&gt;Regards&lt;/div&gt;&lt;/div&gt;&lt;/div&gt;","0"),
 ("46","2","assigned-to-project","New Project Created (Sent to Customer Contacts)","New Project Created","<p>Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>
\n<p>New project is assigned to your company.<br /><br /><strong>Project Name:</strong>&nbsp;{project_name}<br /><strong>Project Start Date:</strong>&nbsp;{project_start_date}</p>
\n<p>You can view the project on the following link:&nbsp;<a href=\"{project_link}\">{project_name}</a></p>
\n<p>We are looking forward hearing from you.<br /><br />Kind Regards,<br />{email_signature}</p>","0"),
 ("48","5","task-commented-to-contacts","New Comment on Task (Sent to Customer Contacts)","New Comment on Task - {task_name}","<span>Dear {contact_firstname} {contact_lastname}</span><br /><br /><span>A comment has been made on the following task:</span><br /><br /><strong>Name:</strong><span> {task_name}</span><br /><strong>Comment:</strong><span> {task_comment}</span><br /><br /><span>You can view the task on the following link: </span><a href=\"{task_link}\">{task_name}</a><br /><br /><span>Kind Regards,</span><br /><span>{email_signature}</span>","1"),
 ("49","1","new-lead-assigned","New Lead Assigned to Staff Member","New lead assigned to you","&lt;p&gt;Hello {lead_assigned}&lt;br&gt;&lt;br&gt;New lead is assigned to you.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Lead Name:&lt;/strong&gt;&amp;nbsp;{lead_name}&lt;br&gt;&lt;strong&gt;Lead Email:&lt;/strong&gt;&amp;nbsp;{lead_email}&lt;/p&gt;&lt;p&gt;&lt;strong&gt;Lead Phone:&lt;/strong&gt;&amp;nbsp;{lead_phone}&lt;/p&gt;&lt;p&gt;&lt;br&gt;You can view the lead on the following link: &lt;a href=\"{lead_link}\"&gt;{lead_name}&lt;/a&gt;&lt;br&gt;&lt;br&gt;Kind Regards,&lt;br&gt;{email_signature}&lt;br&gt;&lt;/p&gt;","0"),
 ("50","3","client-statement","Statement - Account Summary","Account Statement from {statement_from} to {statement_to}","Dear {contact_firstname} {contact_lastname}, <br /><br />Its been a great experience working with you.<br /><br />Attached with this email is a list of all transactions for the period between {statement_from} to {statement_to}<br /><br />For your information your account balance due is total:&nbsp;{statement_balance_due}<br /><br />Please contact us if you need more information.<br /> <br />Kind Regards,<br />{email_signature}","0"),
 ("51","15","ticket-assigned-to-admin","New Ticket Assigned (Sent to Staff)","New support ticket has been assigned to you","<p><span style=\"font-size: 12pt;\">Hi.</span></p>
\n<p><span style=\"font-size: 12pt;\">A new support ticket&nbsp;has been assigned to you.</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Subject</strong>: {ticket_subject}</span><br /><span style=\"font-size: 12pt;\"><strong>Department</strong>: {ticket_department}</span><br /><span style=\"font-size: 12pt;\"><strong>Priority</strong>: {ticket_priority}</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Ticket message:</strong></span><br /><span style=\"font-size: 12pt;\">{ticket_message}</span><br /> <br /><span style=\"font-size: 12pt;\">You can view the ticket on the following link: <a href=\"{ticket_url}\">#{ticket_id}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span></p>","0"),
 ("52","3","new-client-registered-to-admin","New Customer Registration (Sent to admins)","New Customer Registration","Hello.<br /><br />New customer registration on your customer portal:<br /><br /><strong>Firstname:</strong>&nbsp;{contact_firstname}<br /><strong>Lastname:</strong>&nbsp;{contact_lastname}<br /><strong>Company:</strong>&nbsp;{client_company}<br /><strong>Email:</strong>&nbsp;{contact_email}<br /><br />Best Regards","1"),
 ("53","1","new-web-to-lead-form-submitted","Web to lead form submitted - Sent to lead","{lead_name} - We Received Your Request","&lt;p&gt;Hello {lead_assigned}&lt;br&gt;&lt;br&gt;New lead is assigned to you.&lt;br&gt;&lt;br&gt;&lt;strong&gt;Lead Name:&lt;/strong&gt; {lead_name}&lt;br&gt;&lt;strong&gt;Lead Email:&lt;/strong&gt; {lead_email}&lt;br&gt;&lt;br&gt;You can view the lead on the following link: &lt;a href=\"{lead_link}\"&gt;{lead_name}&lt;/a&gt;&lt;br&gt;&lt;br&gt;Kind Regards,&lt;br&gt;{email_signature}&lt;br&gt;&lt;/p&gt;","1"),
 ("54","11","two-factor-authentication","Two Factor Authentication","Confirm Your Login","<p>Hello {staff_firstname}</p>
\n<p style=\"text-align: left;\">You received this email because you have enabled two factor authentication in your account.<br />Use the following code to confirm your login:</p>
\n<p style=\"text-align: left;\"><span style=\"font-size: 18pt;\"><strong>{two_factor_auth_code}<br /><br /></strong><span style=\"font-size: 12pt;\">{email_signature}</span><strong><br /><br /><br /><br /></strong></span></p>","1"),
 ("55","2","project-finished-to-customer","Project Marked as Finished (Sent to Customer Contacts)","Project Marked as Finished","<p>Hello&nbsp;{contact_firstname}&nbsp;{contact_lastname}</p>
\n<p>You are receiving this email because project&nbsp;<strong>{project_name}</strong> has been marked as finished. This project is assigned under your company and we just wanted to keep you up to date.<br /><br />You can view the project on the following link:&nbsp;<a href=\"{project_link}\">{project_name}</a></p>
\n<p>If you have any questions don\'t hesitate to contact us.<br /><br />Kind Regards,<br />{email_signature}</p>","0"),
 ("56","10","credit-note-send-to-client","Send Credit Note To Email","Credit Note With Number #{credit_note_number} Created","Dear&nbsp;{contact_firstname}&nbsp;{contact_lastname}<br /><br />We have attached the credit note with number <strong>#{credit_note_number} </strong>for your reference.<br /><br /><strong>Date:</strong>&nbsp;{credit_note_date}<br /><strong>Total Amount:</strong>&nbsp;{credit_note_total}<br /><br /><span style=\"font-size: 12pt;\">Please contact us for more information.</span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","0"),
 ("57","5","task-status-change-to-staff","Task Status Changed (Sent to Staff)","Task Status Changed","&lt;span style=\"font-size: 12pt;\"&gt;Hi {staff_firstname} {staff_lastname}&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;The marked task as &lt;strong&gt;{task_status}&lt;/strong&gt;&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;&lt;strong&gt;Name:&lt;/strong&gt; {task_name}&lt;/span&gt;&lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;&lt;strong&gt;Due date:&lt;/strong&gt; {task_duedate}&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;You can view the task on the following link: &lt;a href=\"{task_link}\"&gt;{task_name}&lt;/a&gt;&lt;/span&gt;&lt;br&gt; &lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;Kind Regards,&lt;/span&gt;&lt;br&gt;&lt;span style=\"font-size: 12pt;\"&gt;{email_signature}&lt;/span&gt;","0"),
 ("58","5","task-status-change-to-contacts","Task Status Changed (Sent to Customer Contacts)","Task Status Changed","<span style=\"font-size: 12pt;\">Hi {contact_firstname} {contact_lastname}</span><br /> <br /><span style=\"font-size: 12pt;\"><strong>{task_user_take_action}</strong> marked task as <strong>{task_status}</strong></span><br /> <br /><span style=\"font-size: 12pt;\"><strong>Name:</strong> {task_name}</span><br /><span style=\"font-size: 12pt;\"><strong>Due date:</strong> {task_duedate}</span><br /> <br /><span style=\"font-size: 12pt;\">You can view the task on the following link: <a href=\"{task_link}\">{task_name}</a></span><br /> <br /><span style=\"font-size: 12pt;\">Kind Regards,</span><br /><span style=\"font-size: 12pt;\">{email_signature}</span>","1"),
 ("59","11","reminder-email-staff","Staff Reminder Email","You Have a New Reminder!","<p>Hello&nbsp;{staff_firstname}<br /><br /><strong>You have a new reminder&nbsp;linked to&nbsp;{staff_reminder_relation_name}!<br /><br />Reminder description:</strong><br />{staff_reminder_description}<br /><br />Click <a href=\"{staff_reminder_relation_link}\">here</a> to view&nbsp;<a href=\"{staff_reminder_relation_link}\">{staff_reminder_relation_name}</a><br /><br />Best Regards<br /><br /></p>","0"),
 ("62","4","welcome-aboard","New Contact Added/Registered (Welcome Email)","Welcome aboard","Dear {contact_firstname} {contact_lastname}&lt;br&gt;&lt;br&gt;Thank you for registering on the&amp;nbsp;&lt;strong&gt;{coy_name}&lt;/strong&gt;&amp;nbsp;CRM System.&lt;br&gt;&lt;br&gt;We just wanted to say welcome.&lt;br&gt;&lt;br&gt;Please contact us if you need any help.&lt;br&gt;&lt;br&gt;Click here to view your profile: &lt;a href=\"{crm_url}\"&gt;{crm_url}&lt;/a&gt;User Name: &lt;a href=\"{user_name}\"&gt;{user}&lt;/a&gt;Password: &lt;a href=\"{password}\"&gt;{password}&lt;/a&gt;&lt;br&gt;&lt;br&gt;Kind Regards,&amp;nbsp;&lt;br&gt;{email_signature}&lt;br&gt;&lt;br&gt;(This is an automated email, so please don&#039;t reply to this email address)","0");

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_leads` ### 

 DROP TABLE IF EXISTS 0_kv_crm_leads;

CREATE TABLE `0_kv_crm_leads` (
  `lead_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `salutation` int(3) NOT NULL,
  `first_name` varchar(50) NOT NULL,
  `last_name` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `curr_code` varchar(3) NOT NULL,
  `work_phone` varchar(20) NOT NULL,
  `mobile_phone` varchar(20) DEFAULT NULL,
  `address2` varchar(200) NOT NULL,
  `addr_line1` varchar(300) NOT NULL,
  `addr_line2` varchar(300) NOT NULL,
  `city` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `country` int(3) DEFAULT NULL COMMENT 'link to country table',
  `client` varchar(250) NOT NULL,
  `title` varchar(100) DEFAULT NULL,
  `website` varchar(50) DEFAULT NULL,
  `lead_source_id` int(3) DEFAULT NULL COMMENT 'link to lead 0_lead_source',
  `industry_id` int(3) DEFAULT NULL COMMENT 'link to industry table',
  `lead_status_id` int(1) DEFAULT NULL COMMENT 'status of lead',
  `added_by` int(11) NOT NULL COMMENT 'link to 0_users',
  `managed_by` int(11) NOT NULL COMMENT 'link to 0_users',
  `is_converted` int(1) DEFAULT '0',
  `note` mediumtext NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_opportunities` ### 

 DROP TABLE IF EXISTS 0_kv_crm_opportunities;

CREATE TABLE `0_kv_crm_opportunities` (
  `opportunity_id` int(11) NOT NULL AUTO_INCREMENT,
  `opportunity_name` varchar(100) NOT NULL,
  `organization_name` varchar(50) NOT NULL,
  `amount` float DEFAULT NULL,
  `amount_curr_abrev` varchar(5) DEFAULT NULL COMMENT 'Currency id, link to currencies table',
  `type` varchar(30) DEFAULT NULL COMMENT 'Value will be Existing Business, New Business',
  `expected_close_date` datetime DEFAULT NULL,
  `lead_source` int(2) DEFAULT NULL COMMENT 'Link to lead source table',
  `assign_to` int(11) NOT NULL COMMENT 'Link to user table',
  `sale_stage` int(2) NOT NULL COMMENT 'Link to sale stage table',
  `probability` float DEFAULT NULL COMMENT 'percent value',
  `forecast_amount` float DEFAULT NULL,
  `forecast_curr_abrev` varchar(5) DEFAULT NULL COMMENT 'Currency id, link to currencies table',
  `contact_id` int(50) DEFAULT NULL,
  `custome_info` varchar(500) DEFAULT NULL,
  `description` varchar(1000) DEFAULT NULL,
  `status_id` int(11) DEFAULT NULL,
  `crt_date` datetime DEFAULT NULL,
  `upd_date` datetime DEFAULT NULL,
  `cust_id` int(11) DEFAULT NULL COMMENT 'Reference to customer table',
  PRIMARY KEY (`opportunity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_option` ### 

 DROP TABLE IF EXISTS 0_kv_crm_option;

CREATE TABLE `0_kv_crm_option` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `option_name` text COLLATE utf8_unicode_ci NOT NULL,
  `option_value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO 0_kv_crm_option VALUES("1","master_role","2"),
 ("2","home_country","2"),
 ("3","smtp",""),
 ("4","supplier_role","11"),
 ("5","customer_role","7"),
 ("6","allow_customer_to_create_project","");

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_picklist` ### 

 DROP TABLE IF EXISTS 0_kv_crm_picklist;

CREATE TABLE `0_kv_crm_picklist` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `description` varchar(80) NOT NULL COMMENT '0-WO Types , 1- Account Type, 2-Business, 3- Industry, 4- Sales Stage, 5-Contact Active',
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO 0_kv_crm_picklist VALUES("1","Lead Source","0"),
 ("2","Industry List","0"),
 ("3","Business Type","0"),
 ("4","Activity Status","0"),
 ("5","Status","0"),
 ("6","Medium For Activity","0");

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_picklist_values` ### 

 DROP TABLE IF EXISTS 0_kv_crm_picklist_values;

CREATE TABLE `0_kv_crm_picklist_values` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `picklist_id` int(11) NOT NULL DEFAULT '0',
  `id2` int(5) NOT NULL DEFAULT '0',
  `description` varchar(60) NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `picklist_id` (`picklist_id`,`id2`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;

INSERT INTO 0_kv_crm_picklist_values VALUES("1","1","1","Cold Call","0"),
 ("2","1","2","Existing Customer","0"),
 ("3","1","3","External Referral","0"),
 ("4","1","4","Partner","0"),
 ("5","1","5","Web Site","0"),
 ("6","1","6","Other","0"),
 ("7","2","1","Industry 1","0"),
 ("8","2","2","Industry 2","0"),
 ("9","3","1","New Business","0"),
 ("10","3","2","Existing Business","0"),
 ("11","4","1","Contacted","0"),
 ("12","4","2","Delayed","0"),
 ("13","4","3","Agreed","0"),
 ("14","5","1","Not Started","0"),
 ("15","5","2","In Progress","0"),
 ("16","5","3","Testing","0"),
 ("17","5","4","Awaiting For Feedback","0"),
 ("18","5","5","Complete","0"),
 ("19","3","3","test","0"),
 ("20","6","1","Call","0"),
 ("21","6","2","Direct Meeting","0"),
 ("22","6","3","Whatsapp or Message","0"),
 ("23","6","4","Email","0"),
 ("24","6","5","Task","0"),
 ("25","6","6","Invoice","0"),
 ("26","6","7","Project","0");

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_projectmembers` ### 

 DROP TABLE IF EXISTS 0_kv_crm_projectmembers;

CREATE TABLE `0_kv_crm_projectmembers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_projects` ### 

 DROP TABLE IF EXISTS 0_kv_crm_projects;

CREATE TABLE `0_kv_crm_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `name` varchar(600) NOT NULL,
  `description` text,
  `status` int(11) NOT NULL DEFAULT '0',
  `clientid` int(11) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `sales_account` varchar(15) NOT NULL,
  `inventory_account` varchar(15) NOT NULL,
  `cogs_account` varchar(15) NOT NULL,
  `adjustment_account` varchar(15) NOT NULL,
  `wip_account` varchar(15) NOT NULL,
  `dimension_id` int(11) NOT NULL,
  `dimension2_id` int(11) NOT NULL DEFAULT '0',
  `mb_flag` char(1) NOT NULL,
  `units` varchar(20) NOT NULL,
  `billed` tinyint(1) NOT NULL DEFAULT '0',
  `billing_type` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `deadline` date DEFAULT NULL,
  `project_created` date NOT NULL,
  `date_finished` datetime DEFAULT NULL,
  `progress` int(11) DEFAULT '0',
  `progress_from_tasks` int(11) NOT NULL DEFAULT '1',
  `project_cost` decimal(15,2) DEFAULT NULL,
  `project_rate_per_hour` decimal(15,2) DEFAULT NULL,
  `estimated_hours` decimal(15,2) DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `tax_type_id` int(11) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_roles` ### 

 DROP TABLE IF EXISTS 0_kv_crm_roles;

CREATE TABLE `0_kv_crm_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `role_id` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_sales_order_details` ### 

 DROP TABLE IF EXISTS 0_kv_crm_sales_order_details;

CREATE TABLE `0_kv_crm_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT '0',
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `itemType` tinyint(1) NOT NULL,
  `stk_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci,
  `qty_sent` double NOT NULL DEFAULT '0',
  `unit_price` double NOT NULL DEFAULT '0',
  `quantity` double NOT NULL DEFAULT '0',
  `invoiced` double NOT NULL DEFAULT '0',
  `discount_percent` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_sales_orders` ### 

 DROP TABLE IF EXISTS 0_kv_crm_sales_orders;

CREATE TABLE `0_kv_crm_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT '30',
  `version` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `formType` tinyint(1) NOT NULL,
  `debtor_no` int(11) NOT NULL DEFAULT '0',
  `branch_code` int(11) NOT NULL DEFAULT '0',
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_ref` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `project_id` int(11) NOT NULL,
  `billing_type` tinyint(1) NOT NULL,
  `comments` tinytext COLLATE utf8_unicode_ci,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT '0',
  `ship_via` int(11) NOT NULL DEFAULT '0',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `contact_phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deliver_to` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `freight_cost` double NOT NULL DEFAULT '0',
  `from_stk_loc` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT '0',
  `prep_amount` double NOT NULL DEFAULT '0',
  `alloc` double NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_status` ### 

 DROP TABLE IF EXISTS 0_kv_crm_status;

CREATE TABLE `0_kv_crm_status` (
  `status_id` int(11) NOT NULL AUTO_INCREMENT,
  `status_type` int(2) NOT NULL COMMENT '0: Customer, 1: Supplier, 2: Credit, 3: lead, 4: contact, 5: opportunity, 6: Revenue Type, 7: WO Status, 8-inventory, 9-Empl',
  `status` varchar(50) NOT NULL,
  `stt_label` varchar(50) DEFAULT NULL,
  `priority` int(11) DEFAULT '1' COMMENT 'using to distinguish on left filter on crm',
  PRIMARY KEY (`status_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=latin1;

INSERT INTO 0_kv_crm_status VALUES("1","0","Active","","1"),
 ("2","0","InActive","","1"),
 ("3","1","credit status 01","","1"),
 ("4","1","credit status 02","","1"),
 ("5","2","supplier status 01","","1"),
 ("6","2","supplier status 02","","1"),
 ("7","3","Attempted to Contact","","1"),
 ("8","3","Contact in future","","1"),
 ("9","3","Contacted","","1"),
 ("10","3","Junk Lead","","1"),
 ("11","3","Hot Lead","","2"),
 ("12","3","Lost Lead","","2"),
 ("13","3","Not Contacted","","1"),
 ("14","3","Pre Qualified","","1"),
 ("15","3","Qualified","","1"),
 ("16","3","Warm","","1"),
 ("17","3","Company Profile &amp; Terms Sent","","1"),
 ("18","3","Need to follow up","","1"),
 ("19","3","Will call back if interested","","1"),
 ("20","4","contact status 1","","1"),
 ("21","4","contact status 2","","1"),
 ("22","5","Lost Account","","1"),
 ("23","5","Qualification","","1"),
 ("24","5","Needs Analysis","","1"),
 ("25","5","Value Proposition","","1"),
 ("26","5","Proposal/Price Quote","","1"),
 ("27","5","Negotiation/Review","","1"),
 ("28","5","Closed Won","","1"),
 ("29","5","Closed Lost","","1"),
 ("30","5","Closed Lost to Competition","","1"),
 ("31","5","Hot","","2"),
 ("32","5","Lost","","2"),
 ("33","6","High Value","","1"),
 ("34","6","Medium Value","","1"),
 ("35","6","Low Value","","1"),
 ("36","7","Open","","1"),
 ("37","7","Released","","1"),
 ("38","7","Partially Produced","","1"),
 ("39","7","Produced","","1"),
 ("40","8","Active","","1"),
 ("41","8","Inactive","","1"),
 ("42","9","Active","","1"),
 ("43","9","Suspened","","1"),
 ("44","9","Deceased","","1"),
 ("45","9","Retired","","1"),
 ("46","9","Terminated","","1"),
 ("47","11","Open","","1"),
 ("48","11","Delivered","","1"),
 ("49","12","Draft","","1"),
 ("50","12","Ordered","","1"),
 ("51","12","Partially Ordered","","1");

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_status_types` ### 

 DROP TABLE IF EXISTS 0_kv_crm_status_types;

CREATE TABLE `0_kv_crm_status_types` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `status_type` varchar(50) NOT NULL,
  `inactive` int(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO 0_kv_crm_status_types VALUES("1","Supplier","0"),
 ("2","Credit","0"),
 ("3","Lead","0"),
 ("4","Contact","0"),
 ("5","Opportunity","0"),
 ("6","Revenue Type","0"),
 ("7","Work Order Status","0"),
 ("8","Inventory","0"),
 ("9","Employee","0"),
 ("10","Customer","0"),
 ("11","Sales Order","0"),
 ("12","Sales Quotation","0");

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_tasks` ### 

 DROP TABLE IF EXISTS 0_kv_crm_tasks;

CREATE TABLE `0_kv_crm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` mediumtext,
  `description` text,
  `priority` int(11) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `startdate` date NOT NULL,
  `duedate` date DEFAULT NULL,
  `datefinished` datetime DEFAULT NULL,
  `addedfrom` int(11) NOT NULL,
  `is_added_from_contact` tinyint(1) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `recurring_type` varchar(10) DEFAULT NULL,
  `repeat_every` int(11) DEFAULT NULL,
  `recurring` int(11) NOT NULL DEFAULT '0',
  `is_recurring_from` int(11) DEFAULT NULL,
  `cycles` int(11) NOT NULL DEFAULT '0',
  `total_cycles` int(11) NOT NULL DEFAULT '0',
  `custom_recurring` tinyint(1) NOT NULL DEFAULT '0',
  `last_recurring_date` date DEFAULT NULL,
  `type_id` int(11) DEFAULT NULL,
  `type` int(11) DEFAULT NULL COMMENT '1-leads, 2-project, 3-customer, 4-supplier, 5-opportunity',
  `is_public` tinyint(1) NOT NULL DEFAULT '0',
  `billable` tinyint(1) NOT NULL DEFAULT '0',
  `billed` tinyint(1) NOT NULL DEFAULT '0',
  `invoice_id` int(11) NOT NULL DEFAULT '0',
  `hourly_rate` decimal(15,2) NOT NULL DEFAULT '0.00',
  `milestone` int(11) DEFAULT '0',
  `kanban_order` int(11) NOT NULL DEFAULT '0',
  `staffid` int(11) NOT NULL DEFAULT '0',
  `visible_to_client` tinyint(1) NOT NULL DEFAULT '0',
  `deadline_notified` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

 # -------------------------------------------------------------------------------------

### Structure of table `kv_crm_taskstimers` ### 

 DROP TABLE IF EXISTS 0_kv_crm_taskstimers;

CREATE TABLE `0_kv_crm_taskstimers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(11) NOT NULL,
  `start_time` varchar(64) NOT NULL,
  `end_time` varchar(64) DEFAULT NULL,
  `staff_id` int(11) NOT NULL,
  `hourly_rate` decimal(15,2) NOT NULL DEFAULT '0.00',
  `note` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



 # -------------------------------------------------------------------------------------

#ALTER TABLE `0_debtors_master` ADD `user_id` INT(11) NOT NULL AFTER `debtor_ref`;
#ALTER TABLE `0_suppliers` ADD `user_id` INT(11) NOT NULL AFTER `supp_ref`;

#INSERT INTO `0_reflines` (`id`, `trans_type`, `prefix`, `pattern`, `description`, `default`, `inactive`) VALUES (NULL, '33', '', '{001}/{YYYY}', '', '1', '0');
#INSERT INTO `0_reflines` (`id`, `trans_type`, `prefix`, `pattern`, `description`, `default`, `inactive`) VALUES (NULL, '34', '', '{001}/{YYYY}', '', '1', '0');
#INSERT INTO `0_reflines` (`id`, `trans_type`, `prefix`, `pattern`, `description`, `default`, `inactive`) VALUES (NULL, '36', '', '{001}/{YYYY}', '', '1', '0');
