<?php 
/****************************************
/*  Author 	: Abdullah Alshamsi
/*  Module 	: onlinksoft CRM
/*  E-mail 	: admin@onlinksoft.com
/*  Version : 1.0
/*  Http 	: www.onlinksoft.com
/* Function : Estimate/Proposal for Customers
*****************************************/

$page_security = 'SA_OPEN';
$path_to_root="../..";

include_once($path_to_root . "/modules/onlinkCRM/includes/cart_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/modules/onlinkCRM/includes/sales_order_ui.inc");
include_once($path_to_root . "/modules/onlinkCRM/includes/db/sales_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/modules/onlinkCRM/includes/crm.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

add_access_extensions();

set_page_security( @$_SESSION['Items']->trans_type,
	array(	ST_SALESPROPOSAL=>'CRM_ESTIMATES',
			ST_SALESESTIMATE => 'CRM_PROPOSAL'
			),
	array(	'NewProposal' => 'CRM_PROPOSAL',
			'ModifyProposal' => 'CRM_PROPOSAL',
			'NewEstimate' => 'CRM_ESTIMATES',
			'ModifyEstimate' => 'CRM_ESTIMATES',
			'EstimateToOrder' => 'SA_SALESORDER',
			'EstimateToInvoice' => 'SA_SALESINVOICE'
			)
);

$js = '';

if ($SysPrefs->use_popup_windows) {
	$js .= get_js_open_window(900, 500);
}

if (user_use_date_picker()) {
	$js .= get_js_date_picker();
}

if (isset($_GET['ModifyProposal']) && is_numeric($_GET['ModifyProposal'])) {

	$help_context = 'Modifying Sales Proposal';
	$formType = GetRow('kv_crm_sales_orders', array('order_no' => $_GET['ModifyProposal'], 'trans_type' => ST_SALESPROPOSAL));
	if($formType['formType'])
		$_POST['formType'] = $formType['formType'];
	$_SESSION['page_title'] = sprintf( _("Modifying Sales Proposal # %d"), $_GET['ModifyProposal']);
	create_cart(ST_SALESPROPOSAL, $_GET['ModifyProposal']);

} elseif (isset($_GET['ModifyEstimate']) && is_numeric($_GET['ModifyEstimate'])) {

	$help_context = 'Modifying Sales Estimate';
	$_SESSION['page_title'] = sprintf( _("Modifying Sales Estimate # %d"), $_GET['ModifyEstimate']);
	create_cart(ST_SALESESTIMATE, $_GET['ModifyEstimate']);

} elseif (isset($_GET['NewProposal'])) {
	$_SESSION['page_title'] = _($help_context = "New Proposal");
	create_cart(ST_SALESPROPOSAL, 0);
} elseif (isset($_GET['NewEstimate'])) {

	$_SESSION['page_title'] = _($help_context = "New Estimate");
	create_cart(ST_SALESESTIMATE, 0);
} elseif (isset($_GET['NewEstimateToSalesOrder'])) {
	$_SESSION['page_title'] = _($help_context = "Sales Estimate to Order Entry");
	$formType = GetRow('kv_crm_sales_orders', array('order_no' => $_GET['NewEstimateToSalesOrder'], 'trans_type' => ST_SALESESTIMATE));
	if($formType['formType'])
		$_POST['formType'] = $formType['formType'];	
	create_cart(ST_SALESESTIMATE, $_GET['NewEstimateToSalesOrder']);
} elseif (isset($_GET['NewProposalToSalesOrder'])) {
	$_SESSION['page_title'] = _($help_context = "Sales Proposal to Order Entry");
	$formType = GetRow('kv_crm_sales_orders', array('order_no' => $_GET['NewProposalToSalesOrder'], 'trans_type' => ST_SALESPROPOSAL));
	if($formType['formType'] == 1) {
		page($_SESSION['page_title'], false, false, "", $js);
		display_warning(sprintf(_("This proposal cannot be converted to order, because the proposal made aganist Leads. Just convert the %s and from there you can convert it to Order."), "<a href='".$path_to_root."/modules/onlinkCRM/manage/convert_to_customer.php?lead_id=".$formType['debtor_no']."'>"._("lead to customer")."</a>"));
		
		end_page(); exit;
	}
	if($formType['formType'])
		$_POST['formType'] = $formType['formType'];	
	create_cart(ST_SALESPROPOSAL, $_GET['NewProposalToSalesOrder']);
}

page($_SESSION['page_title'], false, false, "", $js);

if (isset($_GET['ModifyProposal']) && crm_is_prepaid_order_open($_GET['ModifyProposal']))
{
	display_error(_("This order cannot be edited because there are invoices or payments related to it, and prepayment terms were used."));
	end_page(); exit;
}
if (isset($_GET['ModifyProposal']))
	check_is_editable(ST_SALESPROPOSAL, $_GET['ModifyProposal']);
elseif (isset($_GET['ModifyEstimate']))
	check_is_editable(ST_SALESESTIMATE, $_GET['ModifyEstimate']);

//-----------------------------------------------------------------------------

if (isset($_GET['AddedID'])) {  //Upon creation of Proposal Successfully

	$order_no = $_GET['AddedID'];

	display_notification_centered(sprintf( _("Proposal # %d has been entered."),$order_no));

	crm_submenu_view(_("&View This Proposal"), ST_SALESPROPOSAL, $order_no);

	crm_submenu_print(_("&Print This Proposal"), ST_SALESPROPOSAL, $order_no, 'prtopt');
	//crm_submenu_print(_("&Email This Proposal"), ST_SALESPROPOSAL, $order_no, null, 1);
	set_focus('prtopt');
	
	submenu_option(_("Make &Order Against This Proposal"),	"/modules/onlinkCRM/estimates.php?NewProposalToSalesOrder=$order_no");

	submenu_option(_("Enter a &New Proposal"),	"/modules/onlinkCRM/estimates.php?NewProposal=Yes");

	display_footer_exit();

} elseif (isset($_GET['UpdatedID'])) {
	$order_no = $_GET['UpdatedID'];

	display_notification_centered(sprintf( _("Proposal # %d has been updated."),$order_no));

	crm_submenu_view(_("&View This Proposal"), ST_SALESPROPOSAL, $order_no);

	crm_submenu_print(_("&Print This Proposal"), ST_SALESPROPOSAL, $order_no, 'prtopt');
	crm_submenu_print(_("&Email This Proposal"), ST_SALESPROPOSAL, $order_no, null, 1);
	set_focus('prtopt');

	submenu_option(_("Confirm Proposal Quantities and Make &Order"),
		"/modules/onlinkCRM/estimates.php?NewProposalToSalesOrder=$order_no");

	submenu_option(_("Select A Different &Proposal"),
		"/modules/onlinkCRM/inquires/propsal_estimate_inquiry.php?type=".ST_SALESPROPOSAL);

	display_footer_exit();

} elseif (isset($_GET['AddedEI'])) {  //Upon creation of Estimate Successfully

	$order_no = $_GET['AddedEI'];

	display_notification_centered(sprintf( _("Estimate # %d has been entered."),$order_no));

	crm_submenu_view(_("&View This Estimate"), ST_SALESESTIMATE, $order_no);

	crm_submenu_print(_("&Print This Estimate"), ST_SALESESTIMATE, $order_no, 'prtopt');
	crm_submenu_print(_("&Email This Estimate"), ST_SALESESTIMATE, $order_no, null, 1);
	set_focus('prtopt');
	
	submenu_option(_("Make &Order Against This Estimate"),	"/modules/onlinkCRM/estimates.php?NewEstimateToSalesOrder=$order_no");

	submenu_option(_("Enter a &New Estimate"),	"/modules/onlinkCRM/estimates.php?NewEstimate=Yes");

	display_footer_exit();

} elseif (isset($_GET['UpdatedEI'])) {
	$order_no = $_GET['UpdatedEI'];

	display_notification_centered(sprintf( _("Estimate # %d has been updated."),$order_no));

	crm_submenu_view(_("&View This Estimate"), ST_SALESESTIMATE, $order_no);

	crm_submenu_print(_("&Print This Estimate"), ST_SALESESTIMATE, $order_no, 'prtopt');
	crm_submenu_print(_("&Email This Estimate"), ST_SALESESTIMATE, $order_no, null, 1);
	set_focus('prtopt');

	submenu_option(_("Confirm Estimate Quantities and Make &Order"),
		"/modules/onlinkCRM/estimates.php?NewProposalToSalesOrder=$order_no");

	submenu_option(_("Select A Different &Estimate"),
		"/modules/onlinkCRM/inquires/propsal_estimate_inquiry.php?type=".ST_SALESESTIMATE);

	display_footer_exit();

} else
	check_edit_conflicts(get_post('cart_id'));
//-----------------------------------------------------------------------------

function copy_to_cart()
{
	$cart = &$_SESSION['Items'];

	$cart->reference = $_POST['ref'];

	$cart->Comments =  $_POST['Comments'];

	$cart->document_date = $_POST['OrderDate'];

	$newpayment = false;

	if (isset($_POST['payment']) && ($cart->payment != $_POST['payment'])) {
		$cart->payment = $_POST['payment'];
		$cart->payment_terms = get_payment_terms($_POST['payment']);
		$newpayment = true;
	}
	if ($cart->payment_terms['cash_sale']) {
		if ($newpayment) {
			$cart->due_date = $cart->document_date;
			$cart->phone = $cart->cust_ref = $cart->delivery_address = '';
			$cart->ship_via = 0;
			$cart->deliver_to = '';
			$cart->prep_amount = 0;
		}
	} else {
		$cart->due_date = $_POST['delivery_date'];
		$cart->cust_ref = $_POST['cust_ref'];
		$cart->deliver_to = $_POST['deliver_to'];
		$cart->delivery_address = $_POST['delivery_address'];
		$cart->phone = $_POST['phone'];
		$cart->ship_via = $_POST['ship_via'];
		if (!$cart->trans_no || ($cart->trans_type == ST_SALESPROPOSAL && !$cart->is_started()))
			$cart->prep_amount = input_num('prep_amount', 0);
	}
	$cart->Location = $_POST['Location'];
	$cart->freight_cost = input_num('freight_cost');
	if (isset($_POST['email']))
		$cart->email =$_POST['email'];
	else
		$cart->email = '';
	$cart->customer_id	= $_POST['customer_id'];
	$cart->Branch = $_POST['branch_id'];
	$cart->sales_type = $_POST['sales_type'];
	$cart->formType = (isset($_POST['formType']) ? $_POST['formType'] : 2 ); // 2 - Customers
	if($cart->trans_type == ST_SALESPROPOSAL && isset($_POST['formType']) && $_POST['formType'] == 1){
		$getLead = GetRow('kv_crm_leads', array('lead_id' => $_POST['customer_id']));
		$cart->cust_ref = $getLead['first_name'].' '.$getLead['last_name'];
	}

	/*if ($cart->trans_type!=ST_SALESPROPOSAL && $cart->trans_type!=ST_SALESESTIMATE) { // 2008-11-12 Joe Hunt
		$cart->dimension_id = $_POST['dimension_id'];
		$cart->dimension2_id = $_POST['dimension2_id'];
	}*/
	$cart->ex_rate = input_num('_ex_rate', null);
}

//-----------------------------------------------------------------------------

function copy_from_cart()
{
	$cart = &$_SESSION['Items'];
	$_POST['ref'] = $cart->reference;
	$_POST['Comments'] = $cart->Comments;

	$_POST['OrderDate'] = $cart->document_date;
	$_POST['delivery_date'] = $cart->due_date;
	$_POST['cust_ref'] = $cart->cust_ref;
	$_POST['freight_cost'] = price_format($cart->freight_cost);

	$_POST['deliver_to'] = $cart->deliver_to;
	$_POST['delivery_address'] = $cart->delivery_address;
	$_POST['phone'] = $cart->phone;
	$_POST['Location'] = $cart->Location;
	$_POST['ship_via'] = $cart->ship_via;

	$_POST['customer_id'] = $cart->customer_id;

	$_POST['branch_id'] = $cart->Branch;
	$_POST['sales_type'] = $cart->sales_type;
	$_POST['prep_amount'] = price_format($cart->prep_amount);
	// POS 
	$_POST['payment'] = $cart->payment;
	if ($cart->trans_type!=ST_SALESPROPOSAL && $cart->trans_type!=ST_SALESESTIMATE) { // 2008-11-12 Joe Hunt
		$_POST['dimension_id'] = $cart->dimension_id;
		$_POST['dimension2_id'] = $cart->dimension2_id;
	}
	$_POST['cart_id'] = $cart->cart_id;
	$_POST['_ex_rate'] = $cart->ex_rate;
}
//--------------------------------------------------------------------------------

function line_start_focus() {
  	global 	$Ajax;

  	$Ajax->activate('items_table');
  	set_focus('_stock_id_edit');
}

//--------------------------------------------------------------------------------
function can_process() {

	global $Refs, $SysPrefs;

	copy_to_cart();

	if (!get_post('customer_id')) {
		display_error(_("There is no customer selected."));
		set_focus('customer_id');
		return false;
	} 		
	
	if (!is_date($_POST['OrderDate'])) {
		display_error(_("The entered date is invalid."));
		set_focus('OrderDate');
		return false;
	}
	if ($_SESSION['Items']->trans_type!=ST_SALESPROPOSAL && $_SESSION['Items']->trans_type!=ST_SALESESTIMATE && !is_date_in_fiscalyear($_POST['OrderDate'])) {
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('OrderDate');
		return false;
	}
	if (count_array($_SESSION['Items']->line_items) == 0)	{
		display_error(_("You must enter at least one non empty item line."));
		set_focus('AddItem');
		return false;
	}
	if (!$SysPrefs->allow_negative_stock() && ($low_stock = $_SESSION['Items']->check_qoh()))
	{
		display_error(_("This document cannot be processed because there is insufficient quantity for items marked."));
		return false;
	}
		
	if (!db_has_currency_rates($_SESSION['Items']->customer_currency, $_POST['OrderDate']))
		return false;
	
   	if ($_SESSION['Items']->get_items_total() < 0) {
		display_error("Invoice total amount cannot be less than zero.");
		return false;
	}
	
	return true;
}

//-----------------------------------------------------------------------------
if (isset($_POST['update'])) {
	copy_to_cart();
	$Ajax->activate('items_table');
}

if (isset($_POST['ProcessOrder']) && can_process()) {

	$modified = ($_SESSION['Items']->trans_no != 0);
	$so_type = $_SESSION['Items']->so_type;

	$ret = $_SESSION['Items']->write(1);
	if ($ret == -1)	{
		display_error(_("The entered reference is already in use."));
		$ref = $Refs->get_next($_SESSION['Items']->trans_type, null, array('date' => Today()));
		if ($ref != $_SESSION['Items']->reference){
			unset($_POST['ref']); // force refresh reference
			display_error(_("The reference number field has been increased. Please save the document again."));
		}
		set_focus('ref');
	} else {
		if (count_array($messages)) { // abort on failure or error messages are lost
			$Ajax->activate('_page_body');
			display_footer_exit();
		}
		$trans_no = key($_SESSION['Items']->trans_no);
		$trans_type = $_SESSION['Items']->trans_type;
		new_doc_date($_SESSION['Items']->document_date);
		processing_end();
		
		if ($modified) {
			if ($trans_type == ST_SALESESTIMATE)
				meta_forward($_SERVER['PHP_SELF'], "UpdatedEI=$trans_no");
			else	
				meta_forward($_SERVER['PHP_SELF'], "UpdatedID=$trans_no");
		} elseif ($trans_type == ST_SALESPROPOSAL) {
			meta_forward($_SERVER['PHP_SELF'], "AddedID=$trans_no");
		} elseif ($trans_type == ST_SALESESTIMATE) {
			$get_customer = CrmGetCustomerContact($_POST['customer_id']);
			
			$to =  array('name' => $get_customer['name'], 'email' => $get_customer['email']);
			$contact = array('name' => $get_customer['name'], 'name2' => '', 'phone' => $get_customer['phone'], 'email' => $get_customer['email'], 'doc_no' => $trans_no);
			$template = array('slug' => 'estimate-send-to-client',  'details' => $contact );
			kv_mail($to, '', '', "html", array(), null, false, $template);

			meta_forward($_SERVER['PHP_SELF'], "AddedEI=$trans_no");
		} else {
			meta_forward($path_to_root.'/sales/sales_order_entry.php', "AddedID=$trans_no");
		}
	}	
}

//--------------------------------------------------------------------------------
function check_item_data(){
	global $SysPrefs;
	
	$is_inventory_item = is_inventory_item(get_post('stock_id'));
	if(!get_post('stock_id_text', true)) {
		display_error( _("Item description cannot be empty."));
		set_focus('stock_id_edit');
		return false;
	}
	elseif (!check_num('qty', 0) || !check_num('Disc', 0, 100)) {
		display_error( _("The item could not be updated because you are attempting to set the quantity ordered to less than 0, or the discount percent to more than 100."));
		set_focus('qty');
		return false;
	} elseif (!check_num('price', 0) && (!$SysPrefs->allow_negative_prices() || $is_inventory_item)) {
		display_error( _("Price for inventory item must be entered and can not be less than 0"));
		set_focus('price');
		return false;
	} elseif (isset($_POST['LineNo']) && isset($_SESSION['Items']->line_items[$_POST['LineNo']])
	    && !check_num('qty', $_SESSION['Items']->line_items[$_POST['LineNo']]->qty_done)) {

		set_focus('qty');
		display_error(_("You attempting to make the quantity ordered a quantity less than has already been delivered. The quantity delivered cannot be modified retrospectively."));
		return false;
	}

	$cost_home = get_unit_cost(get_post('stock_id')); // Added 2011-03-27 Joe Hunt
	$cost = $cost_home / get_exchange_rate_from_home_currency($_SESSION['Items']->customer_currency, $_SESSION['Items']->document_date);
	if (input_num('price') < $cost){
		$dec = user_price_dec();
		$curr = $_SESSION['Items']->customer_currency;
		$price = number_format2(input_num('price'), $dec);
		if ($cost_home == $cost)
			$std_cost = number_format2($cost_home, $dec);
		else
		{
			$price = $curr . " " . $price;
			$std_cost = $curr . " " . number_format2($cost, $dec);
		}
		display_warning(sprintf(_("Price %s is below Standard Cost %s"), $price, $std_cost));
	}	
	$total_amt_entered =  input_num('qty')*input_num('price') +input_num('display_total');
	if(($_SESSION['Items']->trans_type == ST_SALESINVOICE || $_SESSION['Items']->trans_type == ST_CUSTDELIVERY  ) &&$total_amt_entered > $_SESSION['Items']->credit){
		display_error(_("The invoice Total is greater than the customer credit"));
		return false;
	}
	return true;
}

//--------------------------------------------------------------------------------

function handle_update_item(){
	if ($_POST['UpdateItem'] != '' && check_item_data()) {
		$_SESSION['Items']->update_cart_item($_POST['LineNo'], input_num('qty'), input_num('price'),
		 input_num('Disc') / 100, $_POST['item_description'] );
	}
	page_modified();
  line_start_focus();
}

//--------------------------------------------------------------------------------

function handle_delete_item($line_no){
    if ($_SESSION['Items']->some_already_delivered($line_no) == 0) {
	    $_SESSION['Items']->remove_from_cart($line_no);
    } else {
		display_error(_("This item cannot be deleted because some of it has already been delivered."));
    }
    line_start_focus();
}

//--------------------------------------------------------------------------------

function handle_new_item(){

	if (!check_item_data()) {
			return;
	}	
	add_to_order($_SESSION['Items'], get_post('stock_id'), input_num('qty'),
		input_num('price'), input_num('Disc') / 100, get_post('stock_id_text'));

	unset($_POST['_stock_id_edit'], $_POST['stock_id']);
	page_modified();
	line_start_focus();
}

//--------------------------------------------------------------------------------
function  handle_cancel_order(){
	global $path_to_root, $Ajax;

	if ($_SESSION['Items']->trans_type == ST_CUSTDELIVERY) {
		display_notification(_("Direct delivery entry has been cancelled as requested."), 1);
		submenu_option(_("Enter a New Sales Delivery"),	"/sales/sales_order_entry.php?NewDelivery=1");
	} elseif ($_SESSION['Items']->trans_type == ST_SALESINVOICE) {
		display_notification(_("Direct invoice entry has been cancelled as requested."), 1);
		submenu_option(_("Enter a New Sales Invoice"),	"/sales/sales_order_entry.php?NewInvoice=1");
	} elseif ($_SESSION['Items']->trans_type == ST_SALESESTIMATE)
	{
		if ($_SESSION['Items']->trans_no != 0) 
			crm_delete_sales_order(key($_SESSION['Items']->trans_no), $_SESSION['Items']->trans_type);
		display_notification(_("This sales quotation has been cancelled as requested."), 1);
		submenu_option(_("Enter a New Sales Quotation"), "/sales/sales_order_entry.php?NewEstimate=Yes");
	} else { // sales order
		if ($_SESSION['Items']->trans_no != 0) {
			$order_no = key($_SESSION['Items']->trans_no);
			if (crm_sales_order_has_deliveries($order_no))	{
				crm_close_sales_order($order_no);
				display_notification(_("Undelivered part of order has been cancelled as requested."), 1);
				submenu_option(_("Select Another Sales Order for Edition"), "/sales/inquiry/proposal_estimate_inquiry.php?type=".ST_SALESPROPOSAL);
			} else {
				crm_delete_sales_order(key($_SESSION['Items']->trans_no), $_SESSION['Items']->trans_type);

				display_notification(_("This sales order has been cancelled as requested."), 1);
				submenu_option(_("Enter a New Sales Order"), "/sales/sales_order_entry.php?NewProposal=Yes");
			}
		} else {
			processing_end();
			meta_forward($path_to_root.'/index.php','application=orders');
		}
	}
	processing_end();
	display_footer_exit();
}

//--------------------------------------------------------------------------------
function create_cart($type, $trans_no){ 
	global $Refs, $SysPrefs;

	if (!$SysPrefs->db_ok) // create_cart is called before page() where the check is done
		return;

	processing_start();

	if (isset($_GET['NewEstimateToSalesOrder'])){
		$trans_no = $_GET['NewEstimateToSalesOrder'];
		$doc = new CRMCart(ST_SALESESTIMATE, $trans_no, true);
		$doc->Comments = _("Sales Estimate") . " # " . $trans_no;
		$_SESSION['Items'] = $doc;
	} elseif (isset($_GET['NewProposalToSalesOrder'])){
		$trans_no = $_GET['NewProposalToSalesOrder'];
		$doc = new CRMCart(ST_SALESPROPOSAL, $trans_no, true);
		$doc->Comments = _("Sales Proposal") . " # " . $trans_no;
		$_SESSION['Items'] = $doc;
	} elseif($type != ST_SALESPROPOSAL && $type != ST_SALESESTIMATE && $trans_no != 0) { // this is template

		$doc = new CRMCart(ST_SALESPROPOSAL, array($trans_no));
		$doc->trans_type = $type;
		$doc->trans_no = 0;
		$doc->document_date = new_doc_date();
		$doc->due_date = $doc->document_date;
		$doc->reference = $Refs->get_next($doc->trans_type, null, array('date' => Today()));
		//$doc->Comments='';
		foreach($doc->line_items as $line_no => $line) {
			$doc->line_items[$line_no]->qty_done = 0;
		}
		$_SESSION['Items'] = $doc;
	} else
		$_SESSION['Items'] = new CRMCart($type, array($trans_no));
	copy_from_cart();
}

//--------------------------------------------------------------------------------
if (isset($_POST['CancelOrder']))
	handle_cancel_order();

$id = find_submit('Delete');
if ($id!=-1)
	handle_delete_item($id);

if (isset($_POST['UpdateItem']))
	handle_update_item();

if (isset($_POST['AddItem']))
	handle_new_item();

if (isset($_POST['CancelItemChanges'])) {
	line_start_focus();
}

//--------------------------------------------------------------------------------
if ($_SESSION['Items']->fixed_asset)
	check_db_has_disposable_fixed_assets(_("There are no fixed assets defined in the system."));
else
	check_db_has_stock_items(_("There are no inventory items defined in the system."));

check_db_has_customer_branches(_("There are no customers, or there are no customers with branches. Please define customers and customer branches."));

if ($_SESSION['Items']->trans_type == ST_SALESESTIMATE) {
	$idate = _("Estimate Date:");
	$orderitems = _("Sales Estimate Items");
	$cancelorder = _("Cancel Estimate");
	$porder = _("Place Estimate");
	$corder = _("Commit Estimate Changes");
} else {
	if(isset($_GET['NewProposalToSalesOrder']) || isset($_GET['NewEstimateToSalesOrder'])){
		$idate = _("Order Date:");
		$orderitems = _("Sales Order Items");
		$cancelorder = _("Cancel Order");
		$porder = $corder =  _("Place Order");
		//$corder = _("Commit Proposal Changes");
	} else{
		$idate = _("Proposal Date:");
		$orderitems = _("Sales Proposal Items");
		$cancelorder = _("Cancel Proposal");
		$porder = _("Place Proposal");
		$corder = _("Commit Proposal Changes");
	}
}
start_form();

hidden('cart_id');
$customer_error = display_order_header($_SESSION['Items'], !$_SESSION['Items']->is_started(), $idate);

if ($customer_error == "") {
	start_table(TABLESTYLE, "width='80%'", 10);
	echo "<tr><td>";
	display_order_summary($orderitems, $_SESSION['Items'], true);
	echo "</td></tr>";
	echo "<tr><td>";
	display_delivery_details($_SESSION['Items']);
	echo "</td></tr>";
	end_table(1);

	//display_error(input_num('display_total'));
	if ($_SESSION['Items']->trans_no == 0) {

		submit_center_first('ProcessOrder', $porder,    _('Check entered data and save document'), 'default');
		submit_center_last('CancelOrder', $cancelorder,	_('Cancels document entry or removes sales order when editing an old document'));
		submit_js_confirm('CancelOrder', _('You are about to void this Document.\nDo you want to continue?'));
	} else {
		submit_center_first('ProcessOrder', $corder,    _('Validate changes and update document'), 'default');
		submit_center_last('CancelOrder', $cancelorder,	_('Cancels document entry or removes sales order when editing an old document'));
		if ($_SESSION['Items']->trans_type==ST_SALESPROPOSAL)
			submit_js_confirm('CancelOrder', _('You are about to cancel undelivered part of this order.\nDo you want to continue?'));
		else
			submit_js_confirm('CancelOrder', _('You are about to void this Document.\nDo you want to continue?'));
	}

} else {
	display_error($customer_error);
}

end_form();
end_page(); ?>
