<?php
/****************************************
/*  Author  : Kvvaradha
/*  Module  : Kvcodes CRM
/*  E-mail  : admin@kvcodes.com
/*  Version : 1.0
/*  Http    : www.kvcodes.com
*****************************************/
$page_security = 'CRM_CUSTOMERS';
$path_to_root = "../../..";

include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/modules/KvcodesCRM/includes/db/custom_fields_db.inc");
include_once($path_to_root . "/modules/KvcodesCRM/includes/ui/custom_fields_ui.inc");
add_access_extensions();
include_once($path_to_root . "/modules/KvcodesCRM/includes/crm.inc" );
$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
	
add_js_file('../modules/KvcodesCRM/js/nicEdit-latest.js');


include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/modules/KvcodesCRM/includes/crm_contacts_view.inc");
include_once($path_to_root . "/modules/KvcodesCRM/includes/attachment.inc");
include_once($path_to_root . "/admin/db/users_db.inc");
include_once($path_to_root . "/modules/KvcodesCRM/includes/activity.inc");

if(isset($_SESSION['wa_current_user']->type) && $_SESSION['wa_current_user']->type == ST_CUSTOMER) {
	$_POST['customer_id'] = $_SESSION['wa_current_user']->person;
	echo '<style> #delete { display : none; } </style>';	
	$custName = GetSingleValue('debtors_master', 'name', array('debtor_no' => $_SESSION['wa_current_user']->person));
	$help_context = "Profile - ".$custName;
} elseif (isset($_GET['debtor_no'])) {
	$_POST['customer_id'] = $_GET['debtor_no'];
	$help_context = "Customers";
}else
	$help_context = "Customers"; 

page(_($help_context), false, false, "", $js); 


$selected_id = get_post('customer_id','');

function Has_Customer_Shortname($cust_ref) {
	return GetSingleValue('debtors_master', 'COUNT(debtor_no)', ['debtor_ref' => $cust_ref]);
}
//--------------------------------------------------------------------------------------------
function gst_validate($gstNo, $statecode,$debtor)
{

    if($debtor=="Registered") {
        if (strlen($gstNo) == 15) {
            if ($statecode == substr($gstNo, 0, 2)) {

                if (!preg_match("/^([0-9]){2}([a-zA-Z]){5}([0-9]){4}([a-zA-Z]){1}([a-zA-Z0-9]){1}([a-zA-Z]){1}([a-zA-Z0-9]){1}?$/", $gstNo)) {
                    return false;
                } else {
                    return true;
                }
            } else {
                return false;
            }
        } else
            return false;
    }
    else
        return true;

}
function can_process()
{
	if (strlen($_POST['CustName']) == 0) 
	{
		display_error(_("The customer name cannot be empty."));
		set_focus('CustName');
		return false;
	} 

//	if (strlen($_POST['cust_ref']) == 0) {
	//	display_error(_("The customer short name cannot be empty."));
	//	set_focus('cust_ref');
	//	return false;
//	} 
//display_error(json_encode($_POST['customer_id']));
	if (!isset($_POST['customer_id']) && Has_Customer_Shortname($_POST['cust_ref'])) 
	{
		display_error(_("The customer short name already exists."));
		set_focus('cust_ref');
		return false;
	} 
	 if (gst_validate($_POST['tax_id'], $_POST['state_code'], $_POST['debtorscategory']) == false)    {
         display_error("Invalid GST No");
         set_focus('tax_id');
         return false;
     }

     if (gst_validate($_POST['ship_gst'], $_POST['ship_state_code'], $_POST['debtorscategory']) == false)  {
         display_error("Invalid ship GST No ");
         set_focus('ship_gst');
         return false;
     }

	if(isset($_POST['password']) && strlen($_POST['password'])<=3){
		display_error(_("The password entered must be at least 4 characters long."));
		set_focus('password');
		return false;		
	}

	//if(!isset($_POST['customer_id']) && key_in_foreign_table($_POST['cust_ref'], 'users', 'user_id') || key_in_foreign_table($_POST['cust_ref'], 'debtors_master', 'debtor_ref')){
	//	display_error(_("Shor Name is already used."));
	//	set_focus('cust_ref');
	//	return false;
//	}
	if (!check_num('credit_limit', 0))
	{
		display_error(_("The credit limit must be numeric and not less than zero."));
		set_focus('credit_limit');
		return false;		
	} 
	
	if (!check_num('pymt_discount', 0, 100)) 
	{
		display_error(_("The payment discount must be numeric and is expected to be less than 100% and greater than or equal to 0."));
		set_focus('pymt_discount');
		return false;		
	} 
	
	if (!check_num('discount', 0, 100)) 
	{
		display_error(_("The discount percentage must be numeric and is expected to be less than 100% and greater than or equal to 0."));
		set_focus('discount');
		return false;		
	} 

	return true;
}

//--------------------------------------------------------------------------------------------

function handle_submit(&$selected_id)
{
	global $path_to_root, $Ajax, $SysPrefs;

	if (!can_process())
		return;
		
	if ($selected_id) 
	{
		Update('debtors_master',array('debtor_no'=>$_POST['customer_id']),array("name"=>$_POST['CustName'],"debtor_ref"=>$_POST['cust_ref'],"address"=>$_POST['address'],"tax_id"=>$_POST['tax_id'],"curr_code"=>$_POST['curr_code'],"dimension_id"=>$_POST['dimension_id'],"dimension2_id"=>$_POST['dimension2_id'],"credit_status"=>$_POST['credit_status'],"payment_terms"=>$_POST['payment_terms'],"discount"=>$_POST['discount'],"pymt_discount"=>$_POST['pymt_discount'],"credit_limit"=>input_num('credit_limit'),"sales_type"=>$_POST['sales_type'],"notes"=>$_POST['notes'],"debtorscategory"=>$_POST['debtorscategory'],"state_code"=>$_POST['state_code'],"ship_state_code"=>$_POST['ship_state_code'],"ship_address"=>$_POST['ship_address'],"ship_gst"=>$_POST['ship_gst'],"ecom"=>check_value('ecom_enabled'),"reverse_charge"=>check_value('reverse_charge_enabled')));

		// update_customer($_POST['customer_id'], $_POST['CustName'], $_POST['cust_ref'], $_POST['address'],
		// 	$_POST['tax_id'], $_POST['curr_code'], $_POST['dimension_id'], $_POST['dimension2_id'],
		// 	$_POST['credit_status'], $_POST['payment_terms'], input_num('discount') / 100, input_num('pymt_discount') / 100,
		// 	input_num('credit_limit'), $_POST['sales_type'], $_POST['notes']);
		custom_field_update('customer',$_POST['customer_id']);
		update_record_status($_POST['customer_id'], $_POST['inactive'],	'debtors_master', 'debtor_no');
		if(isset($_POST['user_id']) && $_POST['user_id'] > 0 )
			Update('debtors_master', array('debtor_no' => $selected_id), array('user_id' => $_POST['user_id']));

		if(isset($_POST['password']) && strlen($_POST['password']) > 0 ){
			update_user_password($_SESSION["wa_current_user"]->user, 	$_SESSION["wa_current_user"]->username,	md5($_POST['password']));
			$get_customer = CrmGetCustomerContact($_POST['customer_id']);
			
			$to =  array('name' => $_POST['CustName'], 'email' => $get_customer['email']);
			$contact = array('name' => $_POST['CustName'], 'name2' => '', 'phone' => $get_customer['phone'], 'email' => $get_customer['email'], 'login_password' => $_POST['password']);
			$template = array('slug' => 'contact-password-reseted',  'details' => $contact );
			kv_mail($to, '', '', "html", array(), null, false, $template);

			display_notification(_("Your password has been updated."));
		}

		$Ajax->activate('customer_id'); // in case of status change
		display_notification(_("Customer has been updated."));
	} 
	else 
	{ 	//it is a new customer
		begin_transaction();
		$selected_id = $_POST['customer_id'] =Insert('debtors_master',array("name"=>$_POST['CustName'],"debtor_ref"=>$_POST['cust_ref'],"address"=>$_POST['address'],"tax_id"=>$_POST['tax_id'],"curr_code"=>$_POST['curr_code'],"dimension_id"=>$_POST['dimension_id'],"dimension2_id"=>$_POST['dimension2_id'],"credit_status"=>$_POST['credit_status'],"payment_terms"=>$_POST['payment_terms'],"discount"=>$_POST['discount'],"pymt_discount"=>$_POST['pymt_discount'],"credit_limit"=>input_num('credit_limit'),"sales_type"=>$_POST['sales_type'],"notes"=>$_POST['notes'],"debtorscategory"=>$_POST['debtorscategory'],"state_code"=>$_POST['state_code'],"ship_state_code"=>$_POST['ship_state_code'],"ship_address"=>$_POST['ship_address'],"ship_gst"=>$_POST['ship_gst'],"ecom"=>check_value('ecom_enabled'),"reverse_charge"=>check_value('reverse_charge_enabled')));

		// add_customer($_POST['CustName'], $_POST['cust_ref'], $_POST['address'],
		// 	$_POST['tax_id'], $_POST['curr_code'], $_POST['dimension_id'], $_POST['dimension2_id'],
		// 	$_POST['credit_status'], $_POST['payment_terms'], input_num('discount') / 100, input_num('pymt_discount') / 100,
		// 	input_num('credit_limit'), $_POST['sales_type'], $_POST['notes']);

		// $selected_id = $_POST['customer_id'] = db_insert_id();
         custom_field_update('customer',$_POST['customer_id']);
        
		// Update('debtors_master', array('debtor_no' => $selected_id), array('user_id' => $user_id));
		if (isset($SysPrefs->auto_create_branch) && $SysPrefs->auto_create_branch == 1)
		{
			$user_id = Insert('users', array('user_id' => $_POST['cust_ref'], 'real_name' => $_POST['CustName'], 'role_id' => $_POST['CustomerRole'], 'password' => md5($_POST['password']), 'phone' => $_POST['phone'], 'email' => $_POST['email'], 'startup_tab' => 'crm'));

        	add_branch($selected_id, $_POST['CustName'], $_POST['cust_ref'],
                $_POST['address'], $_POST['salesman'], $_POST['area'], $_POST['tax_group_id'], '',
                get_company_pref('default_sales_discount_act'), get_company_pref('debtors_act'), get_company_pref('default_prompt_payment_act'),
                $_POST['location'], $_POST['address'], 0, $_POST['ship_via'], $_POST['notes'], $_POST['bank_account']);
                
        	$selected_branch = db_insert_id();
        
			add_crm_person($_POST['cust_ref'], $_POST['CustName'], '', $_POST['address'], 
				$_POST['phone'], $_POST['phone2'], $_POST['fax'], $_POST['email'], '', '',null,null,$user_id);

			$pers_id = db_insert_id();
			add_crm_contact('cust_branch', 'general', $selected_branch, $pers_id);

			add_crm_contact('customer', 'general', $selected_id, $pers_id);
		}

		

		commit_transaction();

		$to =  array('name' => $_POST['CustName'], 'email' => $_POST['email']);
		$contact = array('name' => $_POST['CustName'], 'name2' => '', 'phone' => $_POST['phone'], 'email' => $_POST['email'], 'user_name' => $_POST['cust_ref'], 'password' => md5('password'));
		//display_error(json_encode($contact));
		$template = array('slug' => 'new-client-created',  'details' => $contact );
		kv_mail($to, '', '', "html", array(), null, false, $template);


		display_notification(_("A new customer has been added."));

		if (isset($SysPrefs->auto_create_branch) && $SysPrefs->auto_create_branch == 1)
			display_notification(_("A default Branch has been automatically created, please check default Branch values by using link below."));
		
		$Ajax->activate('_page_body');
	}
}
//--------------------------------------------------------------------------------------------

if (isset($_POST['submit'])) 
{
	handle_submit($selected_id);
}
//-------------------------------------------------------------------------------------------- 

if (isset($_POST['delete'])) 
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtor_trans'

	if (key_in_foreign_table($selected_id, 'debtor_trans', 'debtor_no'))
	{
		$cancel_delete = 1;
		display_error(_("This customer cannot be deleted because there are transactions that refer to it."));
	} 
	else 
	{
		if (key_in_foreign_table($selected_id, 'sales_orders', 'debtor_no'))
		{
			$cancel_delete = 1;
			display_error(_("Cannot delete the customer record because orders have been created against it."));
		} 
		else 
		{
			if (key_in_foreign_table($selected_id, 'cust_branch', 'debtor_no'))
			{
				$cancel_delete = 1;
				display_error(_("Cannot delete this customer because there are branch records set up against it."));
				//echo "<br> There are " . $myrow[0] . " branch records relating to this customer";
			}
		}
	}
	
	if ($cancel_delete == 0) 
	{ 	//ie not cancelled the delete as a result of above tests
	
		delete_customer($selected_id);

		display_notification(_("Selected customer has been deleted."));
		unset($_POST['customer_id']);
		$selected_id = '';
		$Ajax->activate('_page_body');
	} //end if Delete Customer
}

function customer_settings($selected_id) 
{
	global $SysPrefs, $path_to_root, $page_nested;
	
	if (!$selected_id) {
	 	if (list_updated('customer_id') || !isset($_POST['CustName'])) {
			$_POST['CustName'] = $_POST['cust_ref'] = $_POST['address'] = $_POST['tax_id']  = '';
			$_POST['dimension_id'] = 0;
			$_POST['dimension2_id'] = 0;
			$_POST['sales_type'] = -1;
			$_POST['curr_code']  = get_company_currency();
			$_POST['credit_status']  = -1;
			$_POST['payment_terms']  = $_POST['notes']  = '';

			$_POST['discount']  = $_POST['pymt_discount'] = percent_format(0);
			$_POST['credit_limit']	= price_format($SysPrefs->default_credit_limit());
			$_POST['debtorscategory'] = null;
			$_POST['state_code'] = null;
			$_POST['ship_state_code'] = null;
			$_POST['ship_address'] = null;
			$_POST['ship_gst'] =null;
		}
	} else {
		$myrow = get_customer($selected_id);

		$_POST['CustName'] = $myrow["name"];
		$_POST['cust_ref'] = $myrow["debtor_ref"];
		$_POST['address']  = $myrow["address"];
		$_POST['tax_id']  = $myrow["tax_id"];
		$_POST['dimension_id']  = $myrow["dimension_id"];
		$_POST['dimension2_id']  = $myrow["dimension2_id"];
		$_POST['sales_type'] = $myrow["sales_type"];
		$_POST['curr_code']  = $myrow["curr_code"];
		$_POST['credit_status']  = $myrow["credit_status"];
		$_POST['payment_terms']  = $myrow["payment_terms"];
		$_POST['discount']  = percent_format($myrow["discount"] * 100);
		$_POST['pymt_discount']  = percent_format($myrow["pymt_discount"] * 100);
		$_POST['credit_limit']	= price_format($myrow["credit_limit"]);
		$_POST['notes']  = $myrow["notes"];
		$_POST['inactive'] = $myrow["inactive"];
		$_POST['debtorscategory'] = $myrow["debtorscategory"];
		$_POST['state_code'] = $myrow["state_code"];
		$_POST['ship_state_code'] = $myrow["ship_state_code"];	
		$_POST['ship_address'] = $myrow["ship_address"];
		$_POST['ship_gst'] = $myrow["ship_gst"];
		$_POST['ecom_enabled'] = $myrow["ecom"];
        $_POST['reverse_charge_enabled'] = $myrow["reverse_charge"];
	}

	start_outer_table(TABLESTYLE2);
	table_section(1);
	table_section_title(_("Name and Address"));
	show_debtor_category(_("Category:"), 'debtorscategory', $_POST['debtorscategory'], false);
    show_country(_("Country:"), 'countryid', 99, false);
    show_state(_("State:"), 'state_code', $_POST['state_code'], false);
    show_state(_("Ship State:"), 'ship_state_code', $_POST['ship_state_code'], false); 

	text_row(_("Customer Name:"), 'CustName', $_POST['CustName'], 40, 80);
	text_row(_("Customer Short Name:"), 'cust_ref', null, 30, 30);
	textarea_row(_("Address:"), 'address', $_POST['address'], 35, 5);
	textarea_row(_("Ship Address:"), 'ship_address', $_POST['ship_address'], 35, 5);

    check_row(_("Ecommerce Enabled:"), 'ecom_enabled');
    check_row(_("Reverse Charge Enabled:"), 'reverse_charge_enabled');
    // if (is_new_customer($selected_id))
    //   check_row(_("Tax Exempt:"), 'tax_exempt');
    // else {
    //     hidden('tax_included');
    //     label_row(_("Tax Exempt:"), $_POST['tax_exempt'] ? _('Yes') : _('No'));
    //     }


	// text_row(_("GSTNo:"), 'tax_id', null, 40, 40);
	text_row(_("Bill GSTN:"), 'tax_id', $_POST['tax_id'], 40, 40);
    text_row(_("Ship GSTN:"), 'ship_gst', $_POST['ship_gst'], 40, 40);

	if (!$selected_id || is_new_customer($selected_id) || (!key_in_foreign_table($selected_id, 'debtor_trans', 'debtor_no') &&
		!key_in_foreign_table($selected_id, 'sales_orders', 'debtor_no'))) 	{
		currencies_list_row(_("Customer's Currency:"), 'curr_code', $_POST['curr_code']);
	} 
	else 
	{
		label_row(_("Customer's Currency:"), $_POST['curr_code']);
		hidden('curr_code', $_POST['curr_code']);				
	}
	sales_types_list_row(_("Sales Type/Price List:"), 'sales_type', $_POST['sales_type']);

	if($selected_id){
		record_status_list_row(_("Customer status:"), 'inactive');
		if($myrow['user_id'] == 0)
			kv_unassigned_staffs_row(_("Select User Access:"), 'user_id',null,"No user selected");
	}
	elseif (isset($SysPrefs->auto_create_branch) && $SysPrefs->auto_create_branch == 1)	{
		table_section_title(_("Branch"));
		text_row(_("Phone:"), 'phone', null, 32, 30);
		text_row(_("Secondary Phone Number:"), 'phone2', null, 32, 30);
		text_row(_("Fax Number:"), 'fax', null, 32, 30);
		email_row(_("E-mail:"), 'email', null, 35, 55);
		password_row(_('Password'),'password',null);
		text_row(_("Bank Account Number:"), 'bank_account', null, 30, 60);
		sales_persons_list_row( _("Sales Person:"), 'salesman', null);
		hidden('CustomerRole', GetSingleValue('kv_crm_option', 'option_value', array('option_name' => 'customer_role')));
	}
	if(isset($_SESSION['wa_current_user']->type) && $_SESSION['wa_current_user']->person){
		$_POST['password'] = "";
		password_row(_("New Password:"), 'password', $_POST['password']);		
	}
	//for custom fields
	custom_field_section('customer',$selected_id,1);
	//end custom fields
	table_section(2);

	table_section_title(_("Sales"));
	percent_row(_("Discount Percent:"), 'discount', $_POST['discount'], true);
	percent_row(_("Prompt Payment Discount Percent:"), 'pymt_discount', $_POST['pymt_discount'], true);
	amount_row(_("Credit Limit:"), 'credit_limit', $_POST['credit_limit']);

	payment_terms_list_row(_("Payment Terms:"), 'payment_terms', $_POST['payment_terms']);
	credit_status_list_row(_("Credit Status:"), 'credit_status', $_POST['credit_status']); 
	$dim = get_company_pref('use_dimension');
	if ($dim >= 1)
		dimensions_list_row(_("Dimension")." 1:", 'dimension_id', $_POST['dimension_id'], true, " ", false, 1);
	if ($dim > 1)
		dimensions_list_row(_("Dimension")." 2:", 'dimension2_id', $_POST['dimension2_id'], true, " ", false, 2);
	if ($dim < 1)
		hidden('dimension_id', 0);
	if ($dim < 2)
		hidden('dimension2_id', 0);

	if ($selected_id)  {
		start_row();
		echo '<td class="label">'._('Customer branches').':</td>';
	  	hyperlink_params_td($path_to_root . "/sales/manage/customer_branches.php",
			'<b>'. ($page_nested ?  _("Select or &Add") : _("&Add or Edit ")).'</b>', 
			"debtor_no=".$selected_id.($page_nested ? '&popup=1':''));
		end_row();
	}

	textarea_row(_("General Notes:"), 'notes', null, 35, 5);
	if (!$selected_id && isset($SysPrefs->auto_create_branch) && $SysPrefs->auto_create_branch == 1)
	{
		table_section_title(_("Branch"));
		locations_list_row(_("Default Inventory Location:"), 'location');
		shippers_list_row(_("Default Shipping Company:"), 'ship_via');
		sales_areas_list_row( _("Sales Area:"), 'area', null);
		tax_groups_list_row(_("Tax Group:"), 'tax_group_id', null);
	}
	//for custom fields
	custom_field_section('customer',$selected_id,2);
	//end custom fields
	end_outer_table(1);

	div_start('controls');
	if (@$_REQUEST['popup']) hidden('popup', 1);
	if (!$selected_id)
	{
		submit_center('submit', _("Add New Customer"), true, '', false);
	} 
	else 
	{
		submit_center_first('submit', _("Update Customer"), 
		  _('Update customer data'), false);
		submit_return('select', $selected_id, _("Select this customer and return to document entry."));
		submit_center_last('delete', _("Delete Customer"), 
		  _('Delete customer data if have been never used'), true);
	}
	div_end();
}

//--------------------------------------------------------------------------------------------
$form_media = 0;
check_db_has_sales_types(_("There are no sales types defined. Please define at least one sales type before adding a customer."));
 
start_form(true);

if(isset($_SESSION['wa_current_user']->type) && $_SESSION['wa_current_user']->type == ST_CUSTOMER) {
	$supplier_id = $_POST['customer_id'] = $_SESSION['wa_current_user']->person;
} elseif (db_has_customers()) 
{
	start_table(TABLESTYLE_NOBORDER);
	start_row();
	customer_list_cells(_("Select a customer: "), 'customer_id', null,
		_('New customer'), true, check_value('show_inactive'));
	check_cells(_("Show inactive:"), 'show_inactive', null, true);
	end_row();
	end_table();

	if (get_post('_show_inactive_update')) {
		$Ajax->activate('customer_id');
		set_focus('customer_id');
	}
} 
else 
{
	hidden('customer_id');
}

$result = db_query("SHOW COLUMNS FROM `".TB_PREF."debtors_master` LIKE 'user_id'", "Can't get column");
$exists = (db_num_rows($result))?TRUE:FALSE;

if(!$exists){
	$result = db_query("ALTER TABLE `".TB_PREF."debtors_master` ADD `user_id` INT(11) NOT NULL  DEFAULT '0' AFTER `debtor_no`", "Can't insert column");
}

if (!$selected_id)
	unset($_POST['_tabs_sel']); // force settings tab for new customer

$tabs_ar = array(
		'settings' => array(_('&General settings'), $selected_id),
		'contacts' => array(_('&Contacts'), $selected_id),
		'tasks' => array(_('&Tasks'), $selected_id),
		'activity' => array(_('&Activity'), $selected_id),
		'attachments' => array(_('&Attachments'), $selected_id),
		'invoice' => array(_('&Project Invoices'), $selected_id),
		'transactions' => array(_('&Transactions'), (user_check_access('SA_SALESTRANSVIEW') ? $selected_id : null)),
		'estimates' => array(_('Sales Estimates'), (user_check_access('SA_SALESTRANSVIEW') ? $selected_id : null)),
		'proposals' => array(_('Sales Proposals'), (user_check_access('SA_SALESTRANSVIEW') ? $selected_id : null)),
		'opportunity' => array(_('Opportunities'), (user_check_access('SA_SALESTRANSVIEW') ? $selected_id : null)),
	); 

if(isset($_SESSION['wa_current_user']->type) && $_SESSION['wa_current_user']->type == ST_CUSTOMER)
	unset($tabs_ar['activity']);
tabbed_content_start('tabs', $tabs_ar);
	
	switch (get_post('_tabs_sel')) {
		default:
		case 'settings':
			$form_media=0;
			customer_settings($selected_id); 
			break;
		case 'contacts':
			$form_media=0;
			$contacts = new crm_contacts('contacts', $selected_id, 'customer');
			$contacts->show();
			break;
		case 'transactions':
			$form_media=0;
			$_GET['customer_id'] = $selected_id;
			include_once($path_to_root."/modules/KvcodesCRM/inquires/customer_inquiry.php");
			break;
		case 'estimates':
			$form_media=0;
			$_GET['type']=	ST_SALESESTIMATE;
			$_GET['customer_id'] = $selected_id;
			include_once($path_to_root."/modules/KvcodesCRM/inquires/proposal_estimate_inquiry.php");
			break;
		case 'proposals':
			$form_media=0;
			$_GET['type']=	ST_SALESPROPOSAL;
			$_GET['customer_id'] = $selected_id;
			include_once($path_to_root."/modules/KvcodesCRM/inquires/proposal_estimate_inquiry.php");
			break;

		case 'tasks' :
			$_GET['type_id'] = $selected_id;
			$_GET['type']= ST_CUSTOMER;  //Customer type
			$form_media=1;
			$_GET['page_level'] = 1;
			$Ajax->activate('_page_body');
			include_once($path_to_root."/modules/KvcodesCRM/tasks/index.php");
			break;
		case 'activity':			
			$_GET['type_id'] = $selected_id;	
			$_GET['type']= ST_CUSTOMER;  //Customer type
			$activity = new activity('activity', $selected_id, 'customers');
			$activity->show();			
			break;
		case 'opportunity' :
			$_GET['type_id'] = $selected_id;
			$_GET['type']= ST_CUSTOMER;  //Customer type
			$form_media=1;
			$_GET['page_level'] = 1;
			$Ajax->activate('_page_body');
			include_once($path_to_root."/modules/KvcodesCRM/inquires/opportunities_inquiry.php");
			break;
		case 'attachments':
			/*$_GET['type_id'] = $selected_id;
			$_GET['type']= 5;  //Customers type
			$_GET['page_level'] = 1;
			include_once($path_to_root."/modules/KvcodesCRM/manage/attachments.php");*/
			$form_media=1;
			$_GET['type_id'] = $selected_id;	
			$_GET['type']= ST_CUSTOMER;  //Customers type
			$attachments = new attachments('attachment', $selected_id, 'customers');
			$attachments->show();
			break;
		case 'invoice':
			$form_media=0;
			$_GET['type']=	ST_PROJECTINVOICE;
			$_GET['customer_id'] = $selected_id;
			include_once($path_to_root."/modules/KvcodesCRM/inquires/invoice_inquiry.php");
			break;
	};
br();
tabbed_content_end();

end_form();
echo "<script type='text/javascript'> kvcodes_crm_nicEditor();  </script> \n";
end_page();

